/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.CatchUpClientException;
import org.neo4j.causalclustering.catchup.TimeoutLoop;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class TimeoutLoopTest {
    @Test
    public void shouldReturnImmediatelyIfFutureIsAlreadyComplete() throws Exception {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        future.complete(12L);
        Supplier<Optional> lastResponseSupplier = () -> Optional.of(1L);
        long value = (Long)TimeoutLoop.waitForCompletion(future, (String)"", lastResponseSupplier, (long)2L, (Log)NullLog.getInstance());
        Assert.assertEquals((long)12L, (long)value);
    }

    @Test
    public void shouldTimeoutIfNoActivity() throws Exception {
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        Mockito.when(future.get(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenThrow(TimeoutException.class).thenReturn((Object)12L);
        Supplier<Optional> lastResponseSupplier = Optional::empty;
        try {
            TimeoutLoop.waitForCompletion((Future)future, (String)"", lastResponseSupplier, (long)1L, (Log)NullLog.getInstance());
            TestCase.fail((String)"Should have timed out");
        }
        catch (CatchUpClientException e) {
            ((CompletableFuture)Mockito.verify((Object)future)).cancel(true);
        }
    }

    @Test
    public void shouldTimeoutIfNoContinuedActivity() throws Exception {
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        Mockito.when(future.get(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenThrow(TimeoutException.class).thenReturn((Object)12L);
        Supplier<Optional> lastResponseSupplier = () -> Optional.of(5L);
        try {
            TimeoutLoop.waitForCompletion((Future)future, (String)"", lastResponseSupplier, (long)1L, (Log)NullLog.getInstance());
            TestCase.fail((String)"Should have timed out");
        }
        catch (CatchUpClientException e) {
            ((CompletableFuture)Mockito.verify((Object)future)).cancel(true);
        }
    }

    @Test
    public void shouldKeepWaitingIfThereIsSomeActivity() throws Exception {
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        Mockito.when(future.get(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenThrow(TimeoutException.class).thenReturn((Object)12L);
        Supplier<Optional> lastResponseSupplier = () -> Optional.of(1L);
        long value = (Long)TimeoutLoop.waitForCompletion((Future)future, (String)"", lastResponseSupplier, (long)2L, (Log)NullLog.getInstance());
        Assert.assertEquals((long)12L, (long)value);
    }

    @Test
    public void shouldTranslateExecutionExceptionToCatchUpClientException() throws Exception {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new RuntimeException("I failed to execute, sorry."));
        try {
            TimeoutLoop.waitForCompletion(future, (String)"", () -> Optional.of(1L), (long)2L, (Log)NullLog.getInstance());
            TestCase.fail((String)"Should have thrown exception");
        }
        catch (CatchUpClientException catchUpClientException) {
            // empty catch block
        }
    }
}

