/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.Protocol;
import org.neo4j.causalclustering.catchup.RequestDecoderDispatcher;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

public class RequestDecoderDispatcherTest {
    private final Protocol<State> protocol = new Protocol<State>(State.two){};
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    @Test
    public void shouldDispatchToRegisteredDecoder() throws Exception {
        RequestDecoderDispatcher dispatcher = new RequestDecoderDispatcher(this.protocol, (LogProvider)this.logProvider);
        ChannelInboundHandler delegateOne = (ChannelInboundHandler)Mockito.mock(ChannelInboundHandler.class);
        ChannelInboundHandler delegateTwo = (ChannelInboundHandler)Mockito.mock(ChannelInboundHandler.class);
        ChannelInboundHandler delegateThree = (ChannelInboundHandler)Mockito.mock(ChannelInboundHandler.class);
        dispatcher.register((Enum)State.one, delegateOne);
        dispatcher.register((Enum)State.two, delegateTwo);
        dispatcher.register((Enum)State.three, delegateThree);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Object msg = new Object();
        dispatcher.channelRead(ctx, msg);
        ((ChannelInboundHandler)Mockito.verify((Object)delegateTwo)).channelRead(ctx, msg);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegateTwo});
        Mockito.verifyZeroInteractions((Object[])new Object[]{delegateOne, delegateThree});
    }

    @Test
    public void shouldLogAWarningIfThereIsNoDecoderForTheMessageType() throws Exception {
        RequestDecoderDispatcher dispatcher = new RequestDecoderDispatcher(this.protocol, (LogProvider)this.logProvider);
        ChannelInboundHandler delegateOne = (ChannelInboundHandler)Mockito.mock(ChannelInboundHandler.class);
        ChannelInboundHandler delegateThree = (ChannelInboundHandler)Mockito.mock(ChannelInboundHandler.class);
        dispatcher.register((Enum)State.one, delegateOne);
        dispatcher.register((Enum)State.three, delegateThree);
        dispatcher.channelRead((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), new Object());
        AssertableLogProvider.LogMatcher matcher = AssertableLogProvider.inLog(RequestDecoderDispatcher.class).warn("Unregistered handler for protocol %s", new Object[]{this.protocol});
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{matcher});
        Mockito.verifyZeroInteractions((Object[])new Object[]{delegateOne, delegateThree});
    }

    private static enum State {
        one,
        two,
        three;

    }
}

