/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.catchup.CatchUpChannelPool;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class CatchUpChannelPoolTest {
    @Test
    public void shouldReUseAChannelThatWasReleased() throws Exception {
        CatchUpChannelPool pool = new CatchUpChannelPool(TestChannel::new);
        TestChannel channelA = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        pool.release((CatchUpChannelPool.Channel)channelA);
        TestChannel channelB = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        Assert.assertSame((Object)channelA, (Object)channelB);
    }

    @Test
    public void shouldCreateANewChannelIfFirstChannelIsDisposed() throws Exception {
        CatchUpChannelPool pool = new CatchUpChannelPool(TestChannel::new);
        TestChannel channelA = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        pool.dispose((CatchUpChannelPool.Channel)channelA);
        TestChannel channelB = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        Assert.assertNotSame((Object)channelA, (Object)channelB);
    }

    @Test
    public void shouldCreateANewChannelIfFirstChannelIsStillActive() throws Exception {
        CatchUpChannelPool pool = new CatchUpChannelPool(TestChannel::new);
        TestChannel channelA = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        TestChannel channelB = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        Assert.assertNotSame((Object)channelA, (Object)channelB);
    }

    @Test
    public void shouldCleanUpOnClose() throws Exception {
        CatchUpChannelPool pool = new CatchUpChannelPool(TestChannel::new);
        TestChannel channelA = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        TestChannel channelB = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        TestChannel channelC = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        pool.release((CatchUpChannelPool.Channel)channelA);
        pool.release((CatchUpChannelPool.Channel)channelC);
        TestChannel channelD = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(2));
        TestChannel channelE = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(2));
        TestChannel channelF = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(2));
        pool.close();
        Assert.assertTrue((boolean)channelA.closed);
        Assert.assertTrue((boolean)channelB.closed);
        Assert.assertTrue((boolean)channelC.closed);
        Assert.assertTrue((boolean)channelD.closed);
        Assert.assertTrue((boolean)channelE.closed);
        Assert.assertTrue((boolean)channelF.closed);
    }

    private static AdvertisedSocketAddress localAddress(int port) {
        return new AdvertisedSocketAddress("localhost", port);
    }

    private static class TestChannel
    implements CatchUpChannelPool.Channel {
        private final AdvertisedSocketAddress address;
        private boolean closed;

        TestChannel(AdvertisedSocketAddress address) {
            this.address = address;
        }

        public AdvertisedSocketAddress destination() {
            return this.address;
        }

        public void close() {
            this.closed = true;
        }
    }
}

