/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import org.junit.Test;
import org.neo4j.causalclustering.VersionDecoder;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

public class VersionDecoderTest {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    @Test
    public void shouldDiscardMessageWithUnknownVersionAndLogAnError() throws Exception {
        byte currentVersion = 1;
        byte messageVersion = 0;
        VersionDecoder versionDecoder = new VersionDecoder((LogProvider)this.logProvider, currentVersion);
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeByte((int)messageVersion);
        versionDecoder.decode(null, incoming, new ArrayList());
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(versionDecoder.getClass()).error("Unsupported version %d, current version is %d", new Object[]{messageVersion, currentVersion})});
    }

    @Test
    public void shouldHandleMessageWithCorrectVersion() throws Exception {
        byte currentVersion = 1;
        VersionDecoder versionDecoder = new VersionDecoder((LogProvider)this.logProvider, currentVersion);
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeByte((int)currentVersion);
        versionDecoder.decode(null, incoming, new ArrayList());
        this.logProvider.assertNoLoggingOccurred();
    }
}

