/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.commandline.dbms.StoreLockChecker;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.server.configuration.ConfigLoader;

public class UnbindFromClusterCommand
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withDatabase();
    private Path homeDir;
    private Path configDir;
    private OutsideWorld outsideWorld;

    UnbindFromClusterCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
    }

    private static Config loadNeo4jConfig(Path homeDir, Path configDir, String databaseName) {
        ConfigLoader configLoader = new ConfigLoader(UnbindFromClusterCommand.settings());
        Config config = configLoader.loadConfig(Optional.of(homeDir.toFile()), Optional.of(configDir.resolve("neo4j.conf").toFile()), new Pair[0]);
        HashMap<String, String> additionalConfig = new HashMap<String, String>();
        additionalConfig.put(DatabaseManagementSystemSettings.active_database.name(), databaseName);
        return config.with(additionalConfig, new Class[0]);
    }

    private static List<Class<?>> settings() {
        return Arrays.asList(GraphDatabaseSettings.class, DatabaseManagementSystemSettings.class);
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        try {
            Config config = UnbindFromClusterCommand.loadNeo4jConfig(this.homeDir, this.configDir, arguments.parse("database", args));
            Path pathToSpecificDatabase = ((File)config.get(DatabaseManagementSystemSettings.database_path)).toPath();
            Validators.CONTAINS_EXISTING_DATABASE.validate((Object)pathToSpecificDatabase.toFile());
            if (Files.exists(Paths.get(pathToSpecificDatabase.toString(), "cluster-state"), new LinkOption[0])) {
                this.confirmTargetDirectoryIsWritable(pathToSpecificDatabase);
                this.deleteClusterStateIn(this.clusterStateFrom(pathToSpecificDatabase));
            } else {
                this.outsideWorld.stdErrLine(String.format("No cluster state found in %s. No work perfomed.", pathToSpecificDatabase));
            }
        }
        catch (StoreLockException e) {
            throw new CommandFailed("Database is currently locked. Please shutdown Neo4j.", (Exception)((Object)e));
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        catch (IOException | CannotWriteException | UnbindFailureException e) {
            throw new CommandFailed("Unbind failed: " + e.getMessage(), (Exception)e);
        }
    }

    private void confirmTargetDirectoryIsWritable(Path pathToSpecificDatabase) throws CommandFailed, CannotWriteException, IOException {
        Closeable ignored = StoreLockChecker.check((Path)pathToSpecificDatabase);
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignored.close();
            }
        }
    }

    private Path clusterStateFrom(Path target) {
        return Paths.get(target.toString(), "cluster-state");
    }

    private void deleteClusterStateIn(Path target) throws UnbindFailureException {
        try {
            FileUtils.deleteRecursively((File)target.toFile());
        }
        catch (IOException e) {
            throw new UnbindFailureException(e);
        }
    }

    private class UnbindFailureException
    extends Exception {
        UnbindFailureException(Exception e) {
            super(e);
        }

        UnbindFailureException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("unbind", new String[0]);
        }

        public Arguments allArguments() {
            return arguments;
        }

        public String summary() {
            return "Removes cluster state data from the specified database.";
        }

        public String description() {
            return "Removes cluster state data from the specified database making it suitable for use in single instance database, or for seeding a new cluster.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new UnbindFromClusterCommand(homeDir, configDir, outsideWorld);
        }
    }
}

