/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.io.File;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HazelcastDiscoveryServiceFactory;
import org.neo4j.causalclustering.readreplica.EnterpriseReadReplicaEditionModule;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.util.CustomIOConfigValidator;

public class ReadReplicaGraphDatabase
extends GraphDatabaseFacade {
    public static final String CUSTOM_IO_EXCEPTION_MESSAGE = "Read replica mode is not allowed with custom IO integrations";

    public ReadReplicaGraphDatabase(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        this(storeDir, params, dependencies, new HazelcastDiscoveryServiceFactory());
    }

    public ReadReplicaGraphDatabase(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, DiscoveryServiceFactory discoveryServiceFactory) {
        CustomIOConfigValidator.assertCustomIOConfigNotUsed((Config)new Config(params), (String)CUSTOM_IO_EXCEPTION_MESSAGE);
        Function<PlatformModule, EditionModule> factory = platformModule -> new EnterpriseReadReplicaEditionModule((PlatformModule)platformModule, discoveryServiceFactory);
        new GraphDatabaseFacadeFactory(DatabaseInfo.READ_REPLICA, factory).initFacade(storeDir, params, dependencies, (GraphDatabaseFacade)this);
    }
}

