/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.io.IOException;
import org.neo4j.causalclustering.catchup.storecopy.CopiedStoreRecovery;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreFetcher;
import org.neo4j.causalclustering.catchup.storecopy.StreamingTransactionsFailedException;
import org.neo4j.causalclustering.catchup.storecopy.TemporaryStoreDirectory;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.Log;

public class CopyStoreSafely {
    private final FileSystemAbstraction fs;
    private final LocalDatabase localDatabase;
    private final CopiedStoreRecovery copiedStoreRecovery;
    private final Log log;

    public CopyStoreSafely(FileSystemAbstraction fs, LocalDatabase localDatabase, CopiedStoreRecovery copiedStoreRecovery, Log log) {
        this.fs = fs;
        this.localDatabase = localDatabase;
        this.copiedStoreRecovery = copiedStoreRecovery;
        this.log = log;
    }

    public void copyWholeStoreFrom(MemberId source, StoreId expectedStoreId, StoreFetcher storeFetcher) throws IOException, StoreCopyFailedException, StreamingTransactionsFailedException {
        try (TemporaryStoreDirectory tempStore = new TemporaryStoreDirectory(this.fs, this.localDatabase.storeDir());){
            storeFetcher.copyStore(source, expectedStoreId, tempStore.storeDir());
            this.copiedStoreRecovery.recoverCopiedStore(tempStore.storeDir());
            this.localDatabase.replaceWith(tempStore.storeDir());
        }
        this.log.info("Replaced store with one downloaded from %s", new Object[]{source});
    }
}

