/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.routing;

import java.util.Optional;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.routing.CoreMemberSelectionException;
import org.neo4j.causalclustering.messaging.routing.CoreMemberSelectionStrategy;

public class NotMyselfSelectionStrategy
implements CoreMemberSelectionStrategy {
    private final CoreTopologyService discoveryService;
    private final MemberId myself;

    public NotMyselfSelectionStrategy(CoreTopologyService discoveryService, MemberId myself) {
        this.discoveryService = discoveryService;
        this.myself = myself;
    }

    @Override
    public MemberId coreMember() throws CoreMemberSelectionException {
        Optional<MemberId> member = this.discoveryService.coreServers().members().stream().filter(coreMember -> !coreMember.equals(this.myself)).findFirst();
        if (member.isPresent()) {
            return member.get();
        }
        throw new CoreMemberSelectionException("No core servers available");
    }
}

