/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.routing;

import java.util.Iterator;
import java.util.Random;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.routing.CoreMemberSelectionException;
import org.neo4j.causalclustering.messaging.routing.CoreMemberSelectionStrategy;

public class ConnectToRandomCoreMember
implements CoreMemberSelectionStrategy {
    private final TopologyService discoveryService;
    private final Random random = new Random();

    public ConnectToRandomCoreMember(TopologyService discoveryService) {
        this.discoveryService = discoveryService;
    }

    @Override
    public MemberId coreMember() throws CoreMemberSelectionException {
        MemberId member;
        CoreTopology coreTopology = this.discoveryService.coreServers();
        if (coreTopology.members().size() == 0) {
            throw new CoreMemberSelectionException("No core servers available");
        }
        int skippedServers = this.random.nextInt(coreTopology.members().size());
        Iterator<MemberId> iterator = coreTopology.members().iterator();
        do {
            member = iterator.next();
        } while (skippedServers-- > 0);
        return member;
    }
}

