/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.config.Config;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.spi.properties.GroupProperty;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyListenerService;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.HazelcastClusterTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class HazelcastCoreTopologyService
extends LifecycleAdapter
implements CoreTopologyService {
    private static final long HAZELCAST_IS_HEALTHY_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(10L);
    private final org.neo4j.kernel.configuration.Config config;
    private final MemberId myself;
    private final Log log;
    private final Log userLog;
    private final CoreTopologyListenerService listenerService;
    private final JobScheduler scheduler;
    private String membershipRegistrationId;
    private JobScheduler.JobHandle jobHandle;
    private HazelcastInstance hazelcastInstance;
    private volatile ReadReplicaTopology latestReadReplicaTopology;
    private volatile CoreTopology latestCoreTopology;

    HazelcastCoreTopologyService(org.neo4j.kernel.configuration.Config config, MemberId myself, JobScheduler jobScheduler, LogProvider logProvider, LogProvider userLogProvider) {
        this.config = config;
        this.myself = myself;
        this.scheduler = jobScheduler;
        this.listenerService = new CoreTopologyListenerService();
        this.log = logProvider.getLog(this.getClass());
        this.userLog = userLogProvider.getLog(this.getClass());
    }

    @Override
    public void addCoreTopologyListener(CoreTopologyService.Listener listener) {
        this.listenerService.addCoreTopologyListener(listener);
        listener.onCoreTopologyChange(this.coreServers());
    }

    @Override
    public boolean setClusterId(ClusterId clusterId) {
        return HazelcastClusterTopology.casClusterId(this.hazelcastInstance, clusterId);
    }

    public void start() {
        this.hazelcastInstance = this.createHazelcastInstance();
        this.log.info("Cluster discovery service started");
        this.membershipRegistrationId = this.hazelcastInstance.getCluster().addMembershipListener((MembershipListener)new OurMembershipListener());
        this.refreshCoreTopology();
        this.refreshReadReplicaTopology();
        this.listenerService.notifyListeners(this.coreServers());
        try {
            this.scheduler.start();
        }
        catch (Throwable throwable) {
            this.log.debug("Failed to start job scheduler.");
            return;
        }
        JobScheduler.Group group = new JobScheduler.Group("Scheduler", JobScheduler.SchedulingStrategy.POOLED);
        this.jobHandle = this.scheduler.scheduleRecurring(group, () -> {
            this.refreshCoreTopology();
            this.refreshReadReplicaTopology();
        }, ((Long)this.config.get(CausalClusteringSettings.cluster_topology_refresh)).longValue(), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.log.info(String.format("HazelcastCoreTopologyService stopping and unbinding from %s", this.config.get(CausalClusteringSettings.discovery_listen_address)));
        try {
            this.hazelcastInstance.getCluster().removeMembershipListener(this.membershipRegistrationId);
            this.hazelcastInstance.getLifecycleService().terminate();
        }
        catch (Throwable e) {
            this.log.warn("Failed to stop Hazelcast", e);
        }
        finally {
            this.jobHandle.cancel(true);
        }
    }

    private HazelcastInstance createHazelcastInstance() {
        System.setProperty(GroupProperty.WAIT_SECONDS_BEFORE_JOIN.getName(), "1");
        JoinConfig joinConfig = new JoinConfig();
        joinConfig.getMulticastConfig().setEnabled(false);
        joinConfig.getAwsConfig().setEnabled(false);
        TcpIpConfig tcpIpConfig = joinConfig.getTcpIpConfig();
        tcpIpConfig.setEnabled(true);
        List initialMembers = (List)this.config.get(CausalClusteringSettings.initial_discovery_members);
        for (AdvertisedSocketAddress address : initialMembers) {
            tcpIpConfig.addMember(address.toString());
        }
        this.log.info("Discovering cluster with initial members: " + initialMembers);
        Setting<ListenSocketAddress> discovery_listen_address = CausalClusteringSettings.discovery_listen_address;
        ListenSocketAddress hazelcastAddress = (ListenSocketAddress)this.config.get(discovery_listen_address);
        InterfacesConfig interfaces = new InterfacesConfig();
        interfaces.addInterface(hazelcastAddress.getHostname());
        NetworkConfig networkConfig = new NetworkConfig();
        networkConfig.setInterfaces(interfaces);
        networkConfig.setPort(hazelcastAddress.getPort());
        networkConfig.setJoin(joinConfig);
        networkConfig.setPortAutoIncrement(false);
        Config c = new Config();
        c.setProperty(GroupProperty.OPERATION_CALL_TIMEOUT_MILLIS.getName(), String.valueOf(10000));
        c.setProperty(GroupProperty.MERGE_NEXT_RUN_DELAY_SECONDS.getName(), "10");
        c.setProperty(GroupProperty.MERGE_FIRST_RUN_DELAY_SECONDS.getName(), "10");
        c.setProperty(GroupProperty.INITIAL_MIN_CLUSTER_SIZE.getName(), String.valueOf(this.minimumClusterSizeThatCanTolerateOneFaultForExpectedClusterSize()));
        c.setProperty(GroupProperty.LOGGING_TYPE.getName(), "none");
        c.setNetworkConfig(networkConfig);
        MemberAttributeConfig memberAttributeConfig = HazelcastClusterTopology.buildMemberAttributes(this.myself, this.config);
        c.setMemberAttributeConfig(memberAttributeConfig);
        this.userLog.info("Waiting for other members to join cluster before continuing...");
        DelayedLog delayedLog = new DelayedLog("The server has not been able to connect in a timely fashion to the cluster. Please consult the logs for more details. Rebooting the server may solve the problem", this.log);
        JobScheduler.JobHandle jobHandle = this.scheduler.schedule(new JobScheduler.Group(this.getClass().toString(), JobScheduler.SchedulingStrategy.POOLED), (Runnable)delayedLog, HAZELCAST_IS_HEALTHY_TIMEOUT_MS, TimeUnit.MILLISECONDS);
        delayedLog.setJobHandle(jobHandle);
        try {
            this.hazelcastInstance = Hazelcast.newHazelcastInstance((Config)c);
            delayedLog.stop();
        }
        catch (HazelcastException e) {
            String errorMessage = String.format("Hazelcast was unable to start with setting: %s = %s", discovery_listen_address.name(), this.config.get(discovery_listen_address));
            this.userLog.error(errorMessage);
            this.log.error(errorMessage, (Throwable)e);
            throw new RuntimeException(e);
        }
        return this.hazelcastInstance;
    }

    private Integer minimumClusterSizeThatCanTolerateOneFaultForExpectedClusterSize() {
        return (Integer)this.config.get(CausalClusteringSettings.expected_core_cluster_size) / 2 + 1;
    }

    @Override
    public ReadReplicaTopology readReplicas() {
        return this.latestReadReplicaTopology;
    }

    @Override
    public CoreTopology coreServers() {
        return this.latestCoreTopology;
    }

    @Override
    public void refreshCoreTopology() {
        this.latestCoreTopology = HazelcastClusterTopology.getCoreTopology(this.hazelcastInstance, this.log);
        this.log.info("Current core topology is %s", new Object[]{this.coreServers()});
        this.listenerService.notifyListeners(this.coreServers());
    }

    private void refreshReadReplicaTopology() {
        this.latestReadReplicaTopology = HazelcastClusterTopology.getReadReplicaTopology(this.hazelcastInstance, this.log);
        this.log.info("Current read replica topology is %s", new Object[]{this.latestReadReplicaTopology});
    }

    private class DelayedLog
    implements Runnable {
        private final String message;
        private final Log log;
        private boolean performLogging = true;
        private JobScheduler.JobHandle jobHandle;

        DelayedLog(String message, Log log) {
            this.message = message;
            this.log = log;
        }

        @Override
        public void run() {
            if (this.performLogging) {
                this.log.warn(this.message);
                this.stop();
            }
            this.jobHandle.cancel(true);
        }

        public void stop() {
            this.performLogging = false;
        }

        void setJobHandle(JobScheduler.JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }
    }

    private class OurMembershipListener
    implements MembershipListener {
        private OurMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            HazelcastCoreTopologyService.this.log.info("Core member added %s", new Object[]{membershipEvent});
            HazelcastCoreTopologyService.this.refreshCoreTopology();
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            HazelcastCoreTopologyService.this.log.info("Core member removed %s", new Object[]{membershipEvent});
            HazelcastCoreTopologyService.this.refreshCoreTopology();
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }
    }
}

