/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaAddresses;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddressFormat;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;

class HazelcastClusterTopology {
    static final String READ_REPLICA_BOLT_ADDRESS_MAP_NAME = "read-replicas";
    static final String CLUSTER_UUID = "cluster_uuid";
    static final String MEMBER_UUID = "member_uuid";
    static final String TRANSACTION_SERVER = "transaction_server";
    static final String DISCOVERY_SERVER = "discovery_server";
    static final String RAFT_SERVER = "raft_server";
    static final String CLIENT_CONNECTOR_ADDRESSES = "client_connector_addresses";

    HazelcastClusterTopology() {
    }

    static ReadReplicaTopology getReadReplicaTopology(HazelcastInstance hazelcastInstance, Log log) {
        Set<ReadReplicaAddresses> readReplicas = Collections.emptySet();
        ClusterId clusterId = null;
        if (hazelcastInstance != null) {
            readReplicas = HazelcastClusterTopology.readReplicas(hazelcastInstance);
            clusterId = HazelcastClusterTopology.getClusterId(hazelcastInstance);
        } else {
            log.info("Cannot currently bind to distributed discovery service.");
        }
        return new ReadReplicaTopology(clusterId, readReplicas);
    }

    static CoreTopology getCoreTopology(HazelcastInstance hazelcastInstance, Log log) {
        Map<MemberId, CoreAddresses> coreMembers = Collections.emptyMap();
        boolean canBeBootstrapped = false;
        ClusterId clusterId = null;
        if (hazelcastInstance != null) {
            Set hzMembers = hazelcastInstance.getCluster().getMembers();
            canBeBootstrapped = HazelcastClusterTopology.canBeBootstrapped(hzMembers);
            coreMembers = HazelcastClusterTopology.toCoreMemberMap(hzMembers, log);
            clusterId = HazelcastClusterTopology.getClusterId(hazelcastInstance);
        } else {
            log.info("Cannot currently bind to distributed discovery service.");
        }
        return new CoreTopology(clusterId, canBeBootstrapped, coreMembers);
    }

    private static ClusterId getClusterId(HazelcastInstance hazelcastInstance) {
        IAtomicReference uuidReference = hazelcastInstance.getAtomicReference(CLUSTER_UUID);
        UUID uuid = (UUID)uuidReference.get();
        return uuid != null ? new ClusterId(uuid) : null;
    }

    static boolean casClusterId(HazelcastInstance hazelcastInstance, ClusterId clusterId) {
        IAtomicReference uuidReference = hazelcastInstance.getAtomicReference(CLUSTER_UUID);
        return uuidReference.compareAndSet(null, (Object)clusterId.uuid()) || ((UUID)uuidReference.get()).equals(clusterId.uuid());
    }

    private static Set<ReadReplicaAddresses> readReplicas(HazelcastInstance hazelcastInstance) {
        IMap readReplicaMap = hazelcastInstance.getMap(READ_REPLICA_BOLT_ADDRESS_MAP_NAME);
        return readReplicaMap.entrySet().stream().map(entry -> new ReadReplicaAddresses(ClientConnectorAddresses.fromString((String)entry.getValue()))).collect(Collectors.toSet());
    }

    private static boolean canBeBootstrapped(Set<Member> coreMembers) {
        Iterator<Member> iterator = coreMembers.iterator();
        return iterator.hasNext() && iterator.next().localMember();
    }

    static Map<MemberId, CoreAddresses> toCoreMemberMap(Set<Member> members, Log log) {
        HashMap<MemberId, CoreAddresses> coreMembers = new HashMap<MemberId, CoreAddresses>();
        for (Member member : members) {
            try {
                Pair<MemberId, CoreAddresses> pair = HazelcastClusterTopology.extractMemberAttributes(member);
                coreMembers.put((MemberId)pair.first(), (CoreAddresses)pair.other());
            }
            catch (IllegalArgumentException e) {
                log.warn("Incomplete member attributes supplied from Hazelcast", (Throwable)e);
            }
        }
        return coreMembers;
    }

    static MemberAttributeConfig buildMemberAttributes(MemberId myself, Config config) {
        MemberAttributeConfig memberAttributeConfig = new MemberAttributeConfig();
        memberAttributeConfig.setStringAttribute(MEMBER_UUID, myself.getUuid().toString());
        AdvertisedSocketAddress discoveryAddress = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.discovery_advertised_address);
        memberAttributeConfig.setStringAttribute(DISCOVERY_SERVER, discoveryAddress.toString());
        AdvertisedSocketAddress transactionSource = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.transaction_advertised_address);
        memberAttributeConfig.setStringAttribute(TRANSACTION_SERVER, transactionSource.toString());
        AdvertisedSocketAddress raftAddress = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.raft_advertised_address);
        memberAttributeConfig.setStringAttribute(RAFT_SERVER, raftAddress.toString());
        ClientConnectorAddresses clientConnectorAddresses = ClientConnectorAddresses.extractFromConfig(config);
        memberAttributeConfig.setStringAttribute(CLIENT_CONNECTOR_ADDRESSES, clientConnectorAddresses.toString());
        return memberAttributeConfig;
    }

    static Pair<MemberId, CoreAddresses> extractMemberAttributes(Member member) {
        MemberId memberId = new MemberId(UUID.fromString(member.getStringAttribute(MEMBER_UUID)));
        return Pair.of((Object)memberId, (Object)new CoreAddresses((AdvertisedSocketAddress)SocketAddressFormat.socketAddress((String)member.getStringAttribute(RAFT_SERVER), AdvertisedSocketAddress::new), (AdvertisedSocketAddress)SocketAddressFormat.socketAddress((String)member.getStringAttribute(TRANSACTION_SERVER), AdvertisedSocketAddress::new), ClientConnectorAddresses.fromString(member.getStringAttribute(CLIENT_CONNECTOR_ADDRESSES))));
    }
}

