/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.neo4j.causalclustering.core.consensus.schedule.RenewableTimeoutService;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.HazelcastClusterTopology;
import org.neo4j.causalclustering.discovery.HazelcastConnector;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class HazelcastClient
extends LifecycleAdapter
implements TopologyService {
    static final RenewableTimeoutService.TimeoutName REFRESH_READ_REPLICA = () -> "Refresh Read Replica";
    private final Log log;
    private final ClientConnectorAddresses connectorAddresses;
    private final HazelcastConnector connector;
    private final RenewableTimeoutService renewableTimeoutService;
    private HazelcastInstance hazelcastInstance;
    private RenewableTimeoutService.RenewableTimeout readReplicaRefreshTimer;
    private final long readReplicaTimeToLiveTimeout;
    private final long readReplicaRefreshRate;

    HazelcastClient(HazelcastConnector connector, LogProvider logProvider, Config config, RenewableTimeoutService renewableTimeoutService, long readReplicaTimeToLiveTimeout, long readReplicaRefreshRate) {
        this.connector = connector;
        this.renewableTimeoutService = renewableTimeoutService;
        this.readReplicaRefreshRate = readReplicaRefreshRate;
        this.log = logProvider.getLog(this.getClass());
        this.connectorAddresses = ClientConnectorAddresses.extractFromConfig(config);
        this.readReplicaTimeToLiveTimeout = readReplicaTimeToLiveTimeout;
    }

    @Override
    public CoreTopology coreServers() {
        try {
            return this.retry(hazelcastInstance -> HazelcastClusterTopology.getCoreTopology(hazelcastInstance, this.log));
        }
        catch (Exception e) {
            this.log.info("Failed to read cluster topology from Hazelcast. Continuing with empty (disconnected) topology. Connection will be reattempted on next polling attempt.", (Throwable)e);
            return CoreTopology.EMPTY;
        }
    }

    public void start() throws Throwable {
        this.readReplicaRefreshTimer = this.renewableTimeoutService.create(REFRESH_READ_REPLICA, this.readReplicaRefreshRate, 0L, timeout -> {
            timeout.renew();
            this.retry(this::addReadReplica);
        });
    }

    private Object addReadReplica(HazelcastInstance hazelcastInstance) {
        String uuid = hazelcastInstance.getLocalEndpoint().getUuid();
        String addresses = this.connectorAddresses.toString();
        this.log.debug("Adding read replica into cluster (%s -> %s)", new Object[]{uuid, addresses});
        return hazelcastInstance.getMap("read-replicas").put((Object)uuid, (Object)addresses, this.readReplicaTimeToLiveTimeout, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() throws Throwable {
        if (this.hazelcastInstance != null) {
            try {
                String uuid = this.hazelcastInstance.getLocalEndpoint().getUuid();
                this.hazelcastInstance.getMap("read-replicas").remove((Object)uuid);
                this.hazelcastInstance.shutdown();
            }
            catch (Throwable t) {
                this.log.warn("Unable to shutdown Hazelcast", t);
            }
        }
        this.readReplicaRefreshTimer.cancel();
    }

    private synchronized <T> T retry(Function<HazelcastInstance, T> hazelcastOperation) {
        boolean attemptedConnection = false;
        HazelcastInstanceNotActiveException exception = null;
        while (!attemptedConnection) {
            if (this.hazelcastInstance == null) {
                attemptedConnection = true;
                this.hazelcastInstance = this.connector.connectToHazelcast();
            }
            try {
                return hazelcastOperation.apply(this.hazelcastInstance);
            }
            catch (HazelcastInstanceNotActiveException e) {
                this.hazelcastInstance = null;
                exception = e;
            }
        }
        throw exception;
    }
}

