/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import java.util.concurrent.CompletableFuture;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpResponseAdaptor;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.storecopy.CopiedStoreRecovery;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreFetcher;
import org.neo4j.causalclustering.core.state.CoreState;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshotRequest;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.readreplica.CopyStoreSafely;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class CoreStateDownloader {
    private final FileSystemAbstraction fs;
    private final LocalDatabase localDatabase;
    private final Lifecycle startStopOnStoreCopy;
    private final StoreFetcher storeFetcher;
    private final CatchUpClient catchUpClient;
    private final Log log;
    private final CopiedStoreRecovery copiedStoreRecovery;

    public CoreStateDownloader(FileSystemAbstraction fs, LocalDatabase localDatabase, Lifecycle startStopOnStoreCopy, StoreFetcher storeFetcher, CatchUpClient catchUpClient, LogProvider logProvider, CopiedStoreRecovery copiedStoreRecovery) {
        this.fs = fs;
        this.localDatabase = localDatabase;
        this.startStopOnStoreCopy = startStopOnStoreCopy;
        this.storeFetcher = storeFetcher;
        this.catchUpClient = catchUpClient;
        this.log = logProvider.getLog(this.getClass());
        this.copiedStoreRecovery = copiedStoreRecovery;
    }

    public synchronized void downloadSnapshot(MemberId source, CoreState coreState) throws StoreCopyFailedException {
        try {
            boolean isEmptyStore = this.localDatabase.isEmpty();
            StoreId remoteStoreId = this.storeFetcher.getStoreIdOf(source);
            if (!isEmptyStore && !remoteStoreId.equals(this.localDatabase.storeId())) {
                throw new StoreCopyFailedException("StoreId mismatch and not empty");
            }
            this.startStopOnStoreCopy.stop();
            this.localDatabase.stop();
            this.log.info("Downloading snapshot from core server at %s", new Object[]{source});
            CoreSnapshot coreSnapshot = this.catchUpClient.makeBlockingRequest(source, new CoreSnapshotRequest(), new CatchUpResponseAdaptor<CoreSnapshot>(){

                @Override
                public void onCoreSnapshot(CompletableFuture<CoreSnapshot> signal, CoreSnapshot response) {
                    signal.complete(response);
                }
            });
            if (isEmptyStore) {
                new CopyStoreSafely(this.fs, this.localDatabase, this.copiedStoreRecovery, this.log).copyWholeStoreFrom(source, remoteStoreId, this.storeFetcher);
            } else {
                StoreId localStoreId = this.localDatabase.storeId();
                CatchupResult catchupResult = this.storeFetcher.tryCatchingUp(source, localStoreId, this.localDatabase.storeDir());
                if (catchupResult == CatchupResult.E_TRANSACTION_PRUNED) {
                    this.log.info("Failed to pull transactions from " + source + ". They may have been pruned away.");
                    this.localDatabase.delete();
                    new CopyStoreSafely(this.fs, this.localDatabase, this.copiedStoreRecovery, this.log).copyWholeStoreFrom(source, localStoreId, this.storeFetcher);
                } else if (catchupResult != CatchupResult.SUCCESS_END_OF_STREAM) {
                    throw new StoreCopyFailedException("Failed to download store: " + (Object)((Object)catchupResult));
                }
            }
            coreState.installSnapshot(coreSnapshot);
            this.log.info("Core snapshot installed: " + coreSnapshot);
            this.log.info("Restarting local database", new Object[]{source});
            this.localDatabase.start();
            this.startStopOnStoreCopy.start();
            this.log.info("Local database started", new Object[]{source});
        }
        catch (StoreCopyFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new StoreCopyFailedException(e);
        }
    }
}

