/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.StateMachine;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenStateMachine;
import org.neo4j.causalclustering.core.state.machines.tx.LogIndexTxHeaderEncoding;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionFactory;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionQueue;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class ReplicatedTransactionStateMachine
implements StateMachine<ReplicatedTransaction> {
    private final ReplicatedLockTokenStateMachine lockTokenStateMachine;
    private final int maxBatchSize;
    private final Log log;
    private TransactionQueue queue;
    private long lastCommittedIndex = -1L;

    public ReplicatedTransactionStateMachine(ReplicatedLockTokenStateMachine lockStateMachine, int maxBatchSize, LogProvider logProvider) {
        this.lockTokenStateMachine = lockStateMachine;
        this.maxBatchSize = maxBatchSize;
        this.log = logProvider.getLog(this.getClass());
    }

    public synchronized void installCommitProcess(TransactionCommitProcess commitProcess, long lastCommittedIndex) {
        this.lastCommittedIndex = lastCommittedIndex;
        this.log.info(String.format("Updated lastCommittedIndex to %d", lastCommittedIndex));
        this.queue = new TransactionQueue(this.maxBatchSize, (first, last) -> commitProcess.commit(first, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL));
    }

    @Override
    public synchronized void applyCommand(ReplicatedTransaction replicatedTx, long commandIndex, Consumer<Result> callback) {
        int txLockSessionId;
        if (commandIndex <= this.lastCommittedIndex) {
            this.log.debug("Ignoring transaction at log index %d since already committed up to %d", new Object[]{commandIndex, this.lastCommittedIndex});
            return;
        }
        byte[] extraHeader = LogIndexTxHeaderEncoding.encodeLogIndexAsTxHeader(commandIndex);
        TransactionRepresentation tx = ReplicatedTransactionFactory.extractTransactionRepresentation(replicatedTx, extraHeader);
        int currentTokenId = this.lockTokenStateMachine.currentToken().id();
        if (currentTokenId != (txLockSessionId = tx.getLockSessionId()) && txLockSessionId != -1) {
            callback.accept(Result.of((Exception)((Object)new TransactionFailureException((Status)Status.Transaction.LockSessionExpired, "The lock session in the cluster has changed: [current lock session id:%d, tx lock session id:%d]", new Object[]{currentTokenId, txLockSessionId}))));
        } else {
            try {
                TransactionToApply transaction = new TransactionToApply(tx);
                transaction.onClose(txId -> callback.accept(Result.of(txId)));
                this.queue.queue(transaction);
            }
            catch (Exception e) {
                throw this.panicException(e);
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public long lastAppliedIndex() {
        if (this.queue == null) {
            throw new IllegalStateException("Value has not been installed");
        }
        return this.lastCommittedIndex;
    }

    public synchronized void ensuredApplied() {
        try {
            this.queue.empty();
        }
        catch (Exception e) {
            throw this.panicException(e);
        }
    }

    private IllegalStateException panicException(Exception e) {
        return new IllegalStateException("Failed to locally commit a transaction that has already been committed to the RAFT log. This server cannot process later transactions and needs to be restarted once the underlying cause has been addressed.", e);
    }
}

