/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.token;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.causalclustering.messaging.NetworkFlushableChannelNetty4;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.WritableChannel;

public class ReplicatedTokenRequestSerializer {
    public static void marshal(ReplicatedTokenRequest content, WritableChannel channel) throws IOException {
        channel.putInt(content.type().ordinal());
        StringMarshal.marshal(channel, content.tokenName());
        channel.putInt(content.commandBytes().length);
        channel.put(content.commandBytes(), content.commandBytes().length);
    }

    public static ReplicatedTokenRequest unmarshal(ReadableChannel channel) throws IOException {
        TokenType type = TokenType.values()[channel.getInt()];
        String tokenName = StringMarshal.unmarshal(channel);
        int commandBytesLength = channel.getInt();
        byte[] commandBytes = new byte[commandBytesLength];
        channel.get(commandBytes, commandBytesLength);
        return new ReplicatedTokenRequest(type, tokenName, commandBytes);
    }

    public static void marshal(ReplicatedTokenRequest content, ByteBuf buffer) {
        buffer.writeInt(content.type().ordinal());
        StringMarshal.marshal(buffer, content.tokenName());
        buffer.writeInt(content.commandBytes().length);
        buffer.writeBytes(content.commandBytes());
    }

    public static ReplicatedTokenRequest unmarshal(ByteBuf buffer) {
        TokenType type = TokenType.values()[buffer.readInt()];
        String tokenName = StringMarshal.unmarshal(buffer);
        int commandBytesLength = buffer.readInt();
        byte[] commandBytes = new byte[commandBytesLength];
        buffer.readBytes(commandBytes);
        return new ReplicatedTokenRequest(type, tokenName, commandBytes);
    }

    public static byte[] commandBytes(Collection<StorageCommand> commands) {
        ByteBuf commandBuffer = Unpooled.buffer();
        NetworkFlushableChannelNetty4 channel = new NetworkFlushableChannelNetty4(commandBuffer);
        try {
            new LogEntryWriter((FlushableChannel)channel).serialize(commands);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] commandsBytes = (byte[])commandBuffer.array().clone();
        commandBuffer.release();
        return commandsBytes;
    }

    static Collection<StorageCommand> extractCommands(byte[] commandBytes) {
        ByteBuf txBuffer = Unpooled.wrappedBuffer((byte[])commandBytes);
        NetworkReadableClosableChannelNetty4 channel = new NetworkReadableClosableChannelNetty4(txBuffer);
        VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader((CommandReaderFactory)new RecordStorageCommandReaderFactory());
        LinkedList<StorageCommand> commands = new LinkedList<StorageCommand>();
        try {
            LogEntryCommand entryRead;
            while ((entryRead = (LogEntryCommand)reader.readLogEntry((ReadableClosablePositionAwareChannel)channel)) != null) {
                commands.add(entryRead.getXaCommand());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return commands;
    }
}

