/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipState;
import org.neo4j.causalclustering.core.consensus.term.TermState;
import org.neo4j.causalclustering.core.consensus.vote.VoteState;
import org.neo4j.causalclustering.core.replication.session.GlobalSessionTrackerState;
import org.neo4j.causalclustering.core.state.LongIndexMarshal;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenState;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.SimpleFileStorage;
import org.neo4j.causalclustering.core.state.storage.StateMarshal;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class DumpClusterState {
    private final FileSystemAbstraction fs;
    private final File clusterStateDirectory;
    private final PrintStream out;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("usage: DumpClusterState <graph.db>");
            System.exit(1);
        }
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            File clusterStateDir = new File(args[0], "cluster-state");
            DumpClusterState dumpTool = new DumpClusterState((FileSystemAbstraction)fileSystem, clusterStateDir, System.out);
            dumpTool.dump();
        }
    }

    DumpClusterState(FileSystemAbstraction fs, File clusterStateDirectory, PrintStream out) {
        this.fs = fs;
        this.clusterStateDirectory = clusterStateDirectory;
        this.out = out;
    }

    void dump() throws IOException {
        SimpleFileStorage<MemberId> memberIdStorage = new SimpleFileStorage<MemberId>(this.fs, this.clusterStateDirectory, "core-member-id", new MemberId.Marshal(), (LogProvider)NullLogProvider.getInstance());
        if (memberIdStorage.exists()) {
            MemberId memberId = (MemberId)memberIdStorage.readState();
            this.out.println("core-member-id: " + memberId);
        }
        this.dumpState("last-flushed", new LongIndexMarshal());
        this.dumpState("lock-token", new ReplicatedLockTokenState.Marshal(new MemberId.Marshal()));
        this.dumpState("id-allocation", new IdAllocationState.Marshal());
        this.dumpState("session-tracker", new GlobalSessionTrackerState.Marshal(new MemberId.Marshal()));
        this.dumpState("membership", new RaftMembershipState.Marshal());
        this.dumpState("term", new TermState.Marshal());
        this.dumpState("vote", new VoteState.Marshal(new MemberId.Marshal()));
    }

    private void dumpState(String name, StateMarshal<?> marshal) {
        int rotationSize = (Integer)Config.defaults().get(CausalClusteringSettings.replicated_lock_token_state_size);
        DurableStateStorage storage = new DurableStateStorage(this.fs, this.clusterStateDirectory, name, marshal, rotationSize, (LogProvider)NullLogProvider.getInstance());
        if (storage.exists()) {
            try (Lifespan ignored = new Lifespan(new Lifecycle[]{storage});){
                this.out.println(name + ": " + storage.getInitialState());
            }
        }
    }
}

