/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class CoreStateApplier {
    private final Log log;
    private final NamedThreadFactory threadFactory = new NamedThreadFactory("core-state-applier");
    private final Status status = new Status();
    private ExecutorService applier;
    private boolean isPanic;

    public CoreStateApplier(LogProvider logProvider) {
        this.log = logProvider.getLog(this.getClass());
        this.spawnExecutor();
    }

    private void spawnExecutor() {
        this.status.cancelled = false;
        this.log.info("Spawning new applier");
        this.applier = Executors.newSingleThreadExecutor((ThreadFactory)this.threadFactory);
    }

    public boolean submit(Function<Status, Runnable> abortableTask) {
        if (this.isPanic) {
            this.log.warn("Task submitted while panicked");
            return false;
        }
        if (this.status.cancelled) {
            this.log.warn("Task submitted while cancelled");
        }
        this.applier.submit(this.wrapWithCatchAll(abortableTask.apply(this.status)));
        return true;
    }

    private Runnable wrapWithCatchAll(Runnable task) {
        return () -> {
            try {
                task.run();
            }
            catch (Throwable e) {
                this.log.error("Task had an exception", e);
            }
        };
    }

    public void sync(boolean cancelTasks) {
        if (cancelTasks) {
            this.log.info("Syncing with cancel");
            this.status.cancelled = true;
        } else {
            this.log.info("Syncing");
        }
        this.applier.shutdown();
        do {
            try {
                this.applier.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException ignored) {
                this.log.warn("Unexpected interrupt", (Throwable)ignored);
            }
            if (this.applier.isTerminated()) continue;
            this.log.warn("Applier is taking an unusually long time to sync");
        } while (!this.applier.isTerminated());
        this.spawnExecutor();
    }

    public void panic() {
        this.log.error("Applier panicked");
        this.applier.shutdown();
        this.isPanic = true;
    }

    public class Status {
        private volatile boolean cancelled;

        boolean isCancelled() {
            return this.cancelled;
        }
    }
}

