/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.Progress;
import org.neo4j.causalclustering.core.replication.ProgressTracker;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.replication.session.LocalSessionPool;
import org.neo4j.causalclustering.core.replication.session.OperationContext;
import org.neo4j.causalclustering.core.state.machines.tx.RetryStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class RaftReplicator
extends LifecycleAdapter
implements Replicator,
Listener<MemberId> {
    private final MemberId me;
    private final Outbound<MemberId, RaftMessages.RaftMessage> outbound;
    private final ProgressTracker progressTracker;
    private final LocalSessionPool sessionPool;
    private final RetryStrategy retryStrategy;
    private MemberId leader;
    private volatile boolean shutdown;

    public RaftReplicator(LeaderLocator leaderLocator, MemberId me, Outbound<MemberId, RaftMessages.RaftMessage> outbound, LocalSessionPool sessionPool, ProgressTracker progressTracker, RetryStrategy retryStrategy) {
        this.me = me;
        this.outbound = outbound;
        this.progressTracker = progressTracker;
        this.sessionPool = sessionPool;
        this.retryStrategy = retryStrategy;
        try {
            this.leader = leaderLocator.getLeader();
        }
        catch (NoLeaderFoundException e) {
            this.leader = null;
        }
        leaderLocator.registerListener(this);
    }

    @Override
    public Future<Object> replicate(ReplicatedContent command, boolean trackResult) throws InterruptedException {
        OperationContext session = this.sessionPool.acquireSession();
        DistributedOperation operation = new DistributedOperation(command, session.globalSession(), session.localOperationId());
        Progress progress = this.progressTracker.start(operation);
        RetryStrategy.Timeout timeout = this.retryStrategy.newTimeout();
        do {
            this.assertDatabaseNotShutdown();
            this.outbound.send(this.leader, new RaftMessages.NewEntry.Request(this.me, operation));
            try {
                progress.awaitReplication(timeout.getMillis());
                timeout.increment();
            }
            catch (InterruptedException e) {
                this.progressTracker.abort(operation);
                throw e;
            }
        } while (!progress.isReplicated());
        BiConsumer<Object, Throwable> cleanup = (ignored1, ignored2) -> this.sessionPool.releaseSession(session);
        if (trackResult) {
            progress.futureResult().whenComplete((BiConsumer)cleanup);
        } else {
            cleanup.accept(null, null);
        }
        return progress.futureResult();
    }

    public void receive(MemberId leader) {
        this.leader = leader;
        this.progressTracker.triggerReplicationEvent();
    }

    public void shutdown() {
        this.shutdown = true;
    }

    private void assertDatabaseNotShutdown() throws InterruptedException {
        if (this.shutdown) {
            throw new InterruptedException("Database has been shutdown, transaction cannot be replicated.");
        }
    }
}

