/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.io.IOException;
import java.util.UUID;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.LocalOperationId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.CoreReplicatedContentMarshal;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class DistributedOperation
implements ReplicatedContent {
    private final ReplicatedContent content;
    private final GlobalSession globalSession;
    private final LocalOperationId operationId;

    public DistributedOperation(ReplicatedContent content, GlobalSession globalSession, LocalOperationId operationId) {
        this.content = content;
        this.globalSession = globalSession;
        this.operationId = operationId;
    }

    public GlobalSession globalSession() {
        return this.globalSession;
    }

    public LocalOperationId operationId() {
        return this.operationId;
    }

    public ReplicatedContent content() {
        return this.content;
    }

    public void serialize(WritableChannel channel) throws IOException {
        channel.putLong(this.globalSession().sessionId().getMostSignificantBits());
        channel.putLong(this.globalSession().sessionId().getLeastSignificantBits());
        new MemberId.Marshal().marshal(this.globalSession().owner(), channel);
        channel.putLong(this.operationId.localSessionId());
        channel.putLong(this.operationId.sequenceNumber());
        new CoreReplicatedContentMarshal().marshal(this.content, channel);
    }

    public static DistributedOperation deserialize(ReadableChannel channel) throws IOException, EndOfStreamException {
        long mostSigBits = channel.getLong();
        long leastSigBits = channel.getLong();
        MemberId owner = (MemberId)new MemberId.Marshal().unmarshal(channel);
        GlobalSession globalSession = new GlobalSession(new UUID(mostSigBits, leastSigBits), owner);
        long localSessionId = channel.getLong();
        long sequenceNumber = channel.getLong();
        LocalOperationId localOperationId = new LocalOperationId(localSessionId, sequenceNumber);
        ReplicatedContent content = (ReplicatedContent)new CoreReplicatedContentMarshal().unmarshal(channel);
        return new DistributedOperation(content, globalSession, localOperationId);
    }

    public String toString() {
        return "DistributedOperation{content=" + this.content + ", globalSession=" + this.globalSession + ", operationId=" + this.operationId + '}';
    }
}

