/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.MajorityIncludingSelfQuorum;
import org.neo4j.causalclustering.core.consensus.NewLeaderBarrier;
import org.neo4j.causalclustering.core.consensus.RaftMessageHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Appending;
import org.neo4j.causalclustering.core.consensus.roles.Election;
import org.neo4j.causalclustering.core.consensus.roles.Heart;
import org.neo4j.causalclustering.core.consensus.roles.Pruning;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.roles.Voting;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.logging.Log;

class Candidate
implements RaftMessageHandler {
    Candidate() {
    }

    @Override
    public Outcome handle(RaftMessages.RaftMessage message, ReadableRaftState ctx, Log log) throws IOException {
        Outcome outcome = new Outcome(Role.CANDIDATE, ctx);
        switch (message.type()) {
            case HEARTBEAT: {
                RaftMessages.Heartbeat req = (RaftMessages.Heartbeat)message;
                if (req.leaderTerm() < ctx.term()) break;
                outcome.setNextRole(Role.FOLLOWER);
                log.info("Moving to FOLLOWER state after receiving heartbeat from %s at term %d (I am at %d)", new Object[]{req.from(), req.leaderTerm(), ctx.term()});
                Heart.beat(ctx, outcome, (RaftMessages.Heartbeat)message, log);
                break;
            }
            case APPEND_ENTRIES_REQUEST: {
                RaftMessages.AppendEntries.Request req = (RaftMessages.AppendEntries.Request)message;
                if (req.leaderTerm() < ctx.term()) {
                    RaftMessages.AppendEntries.Response appendResponse = new RaftMessages.AppendEntries.Response(ctx.myself(), ctx.term(), false, req.prevLogIndex(), ctx.entryLog().appendIndex());
                    outcome.addOutgoingMessage(new RaftMessages.Directed(req.from(), appendResponse));
                    break;
                }
                outcome.setNextRole(Role.FOLLOWER);
                log.info("Moving to FOLLOWER state after receiving append entries request from %s at term %d (I am at %d)n", new Object[]{req.from(), req.leaderTerm(), ctx.term()});
                Appending.handleAppendEntriesRequest(ctx, outcome, req, log);
                break;
            }
            case VOTE_RESPONSE: {
                RaftMessages.Vote.Response res = (RaftMessages.Vote.Response)message;
                if (res.term() > ctx.term()) {
                    outcome.setNextTerm(res.term());
                    outcome.setNextRole(Role.FOLLOWER);
                    log.info("Moving to FOLLOWER state after receiving vote response from %s at term %d (I am at %d)", new Object[]{res.from(), res.term(), ctx.term()});
                    break;
                }
                if (res.term() < ctx.term() || !res.voteGranted()) break;
                if (!res.from().equals(ctx.myself())) {
                    outcome.addVoteForMe(res.from());
                }
                if (!MajorityIncludingSelfQuorum.isQuorum(ctx.votingMembers().size(), outcome.getVotesForMe().size())) break;
                outcome.setLeader(ctx.myself());
                Appending.appendNewEntry(ctx, outcome, new NewLeaderBarrier());
                outcome.setLastLogIndexBeforeWeBecameLeader(ctx.entryLog().appendIndex());
                outcome.electedLeader();
                outcome.setNextRole(Role.LEADER);
                log.info("Moving to LEADER state at term %d (I am %s), voted for by %s", new Object[]{ctx.term(), ctx.myself(), outcome.getVotesForMe()});
                break;
            }
            case VOTE_REQUEST: {
                RaftMessages.Vote.Request req = (RaftMessages.Vote.Request)message;
                if (req.term() > ctx.term()) {
                    outcome.getVotesForMe().clear();
                    outcome.setNextRole(Role.FOLLOWER);
                    log.info("Moving to FOLLOWER state after receiving vote request from %s at term %d (I am at %d)", new Object[]{req.from(), req.term(), ctx.term()});
                    Voting.handleVoteRequest(ctx, outcome, req);
                    break;
                }
                outcome.addOutgoingMessage(new RaftMessages.Directed(req.from(), new RaftMessages.Vote.Response(ctx.myself(), outcome.getTerm(), false)));
                break;
            }
            case ELECTION_TIMEOUT: {
                log.info("Election timeout triggered");
                if (Election.start(ctx, outcome, log)) break;
                log.info("Moving to FOLLOWER state after failing to start election");
                outcome.setNextRole(Role.FOLLOWER);
                break;
            }
            case PRUNE_REQUEST: {
                Pruning.handlePruneRequest(outcome, (RaftMessages.PruneRequest)message);
                break;
            }
        }
        return outcome;
    }
}

