/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.outcome;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.ConsensusOutcome;
import org.neo4j.causalclustering.core.consensus.outcome.RaftLogCommand;
import org.neo4j.causalclustering.core.consensus.outcome.ShipCommand;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerStates;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Message;

public class Outcome
implements Message,
ConsensusOutcome {
    private Role nextRole;
    private long term;
    private MemberId leader;
    private long leaderCommit;
    private Collection<RaftLogCommand> logCommands = new ArrayList<RaftLogCommand>();
    private Collection<RaftMessages.Directed> outgoingMessages = new ArrayList<RaftMessages.Directed>();
    private long commitIndex;
    private MemberId votedFor;
    private boolean renewElectionTimeout;
    private boolean needsFreshSnapshot;
    private Set<MemberId> votesForMe;
    private long lastLogIndexBeforeWeBecameLeader;
    private FollowerStates<MemberId> followerStates;
    private Collection<ShipCommand> shipCommands = new ArrayList<ShipCommand>();
    private boolean electedLeader;
    private boolean steppingDown;

    public Outcome(Role currentRole, ReadableRaftState ctx) {
        this.defaults(currentRole, ctx);
    }

    public Outcome(Role nextRole, long term, MemberId leader, long leaderCommit, MemberId votedFor, Set<MemberId> votesForMe, long lastLogIndexBeforeWeBecameLeader, FollowerStates<MemberId> followerStates, boolean renewElectionTimeout, Collection<RaftLogCommand> logCommands, Collection<RaftMessages.Directed> outgoingMessages, Collection<ShipCommand> shipCommands, long commitIndex) {
        this.nextRole = nextRole;
        this.term = term;
        this.leader = leader;
        this.leaderCommit = leaderCommit;
        this.votedFor = votedFor;
        this.votesForMe = new HashSet<MemberId>(votesForMe);
        this.lastLogIndexBeforeWeBecameLeader = lastLogIndexBeforeWeBecameLeader;
        this.followerStates = followerStates;
        this.renewElectionTimeout = renewElectionTimeout;
        this.logCommands.addAll(logCommands);
        this.outgoingMessages.addAll(outgoingMessages);
        this.shipCommands.addAll(shipCommands);
        this.commitIndex = commitIndex;
    }

    private void defaults(Role currentRole, ReadableRaftState ctx) {
        this.nextRole = currentRole;
        this.term = ctx.term();
        this.leader = ctx.leader();
        this.leaderCommit = ctx.leaderCommit();
        this.votedFor = ctx.votedFor();
        this.renewElectionTimeout = false;
        this.needsFreshSnapshot = false;
        this.votesForMe = currentRole == Role.CANDIDATE ? new HashSet<MemberId>(ctx.votesForMe()) : new HashSet();
        this.lastLogIndexBeforeWeBecameLeader = currentRole == Role.LEADER ? ctx.lastLogIndexBeforeWeBecameLeader() : -1L;
        this.followerStates = currentRole == Role.LEADER ? ctx.followerStates() : new FollowerStates();
        this.commitIndex = ctx.commitIndex();
    }

    public void setNextRole(Role nextRole) {
        this.nextRole = nextRole;
    }

    public void setNextTerm(long nextTerm) {
        this.term = nextTerm;
    }

    public void setLeader(MemberId leader) {
        this.leader = leader;
    }

    public void setLeaderCommit(long leaderCommit) {
        this.leaderCommit = leaderCommit;
    }

    public void addLogCommand(RaftLogCommand logCommand) {
        this.logCommands.add(logCommand);
    }

    public void addOutgoingMessage(RaftMessages.Directed message) {
        this.outgoingMessages.add(message);
    }

    public void setVotedFor(MemberId votedFor) {
        this.votedFor = votedFor;
    }

    public void renewElectionTimeout() {
        this.renewElectionTimeout = true;
    }

    public void markNeedForFreshSnapshot() {
        this.needsFreshSnapshot = true;
    }

    public void addVoteForMe(MemberId voteFrom) {
        this.votesForMe.add(voteFrom);
    }

    public void setLastLogIndexBeforeWeBecameLeader(long lastLogIndexBeforeWeBecameLeader) {
        this.lastLogIndexBeforeWeBecameLeader = lastLogIndexBeforeWeBecameLeader;
    }

    public void replaceFollowerStates(FollowerStates<MemberId> followerStates) {
        this.followerStates = followerStates;
    }

    public void addShipCommand(ShipCommand shipCommand) {
        this.shipCommands.add(shipCommand);
    }

    public void electedLeader() {
        assert (!this.steppingDown);
        this.electedLeader = true;
    }

    public void steppingDown() {
        assert (!this.electedLeader);
        this.steppingDown = true;
    }

    public String toString() {
        return "Outcome{nextRole=" + (Object)((Object)this.nextRole) + ", term=" + this.term + ", leader=" + this.leader + ", leaderCommit=" + this.leaderCommit + ", logCommands=" + this.logCommands + ", outgoingMessages=" + this.outgoingMessages + ", commitIndex=" + this.commitIndex + ", votedFor=" + this.votedFor + ", renewElectionTimeout=" + this.renewElectionTimeout + ", needsFreshSnapshot=" + this.needsFreshSnapshot + ", votesForMe=" + this.votesForMe + ", lastLogIndexBeforeWeBecameLeader=" + this.lastLogIndexBeforeWeBecameLeader + ", followerStates=" + this.followerStates + ", shipCommands=" + this.shipCommands + ", electedLeader=" + this.electedLeader + ", steppingDown=" + this.steppingDown + '}';
    }

    public Role getRole() {
        return this.nextRole;
    }

    public long getTerm() {
        return this.term;
    }

    public MemberId getLeader() {
        return this.leader;
    }

    public long getLeaderCommit() {
        return this.leaderCommit;
    }

    public Collection<RaftLogCommand> getLogCommands() {
        return this.logCommands;
    }

    public Collection<RaftMessages.Directed> getOutgoingMessages() {
        return this.outgoingMessages;
    }

    public MemberId getVotedFor() {
        return this.votedFor;
    }

    public boolean electionTimeoutRenewed() {
        return this.renewElectionTimeout;
    }

    @Override
    public boolean needsFreshSnapshot() {
        return this.needsFreshSnapshot;
    }

    public Set<MemberId> getVotesForMe() {
        return this.votesForMe;
    }

    public long getLastLogIndexBeforeWeBecameLeader() {
        return this.lastLogIndexBeforeWeBecameLeader;
    }

    public FollowerStates<MemberId> getFollowerStates() {
        return this.followerStates;
    }

    public Collection<ShipCommand> getShipCommands() {
        return this.shipCommands;
    }

    public boolean isElectedLeader() {
        return this.electedLeader;
    }

    public boolean isSteppingDown() {
        return this.steppingDown;
    }

    @Override
    public long getCommitIndex() {
        return this.commitIndex;
    }

    public void setCommitIndex(long commitIndex) {
        this.commitIndex = commitIndex;
    }
}

