/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.util.concurrent.atomic.AtomicInteger;

class ReferenceCounter {
    private static final int DISPOSED_VALUE = -1;
    private AtomicInteger count = new AtomicInteger();

    ReferenceCounter() {
    }

    boolean increase() {
        int pre;
        do {
            if ((pre = this.count.get()) != -1) continue;
            return false;
        } while (!this.count.compareAndSet(pre, pre + 1));
        return true;
    }

    void decrease() {
        int pre;
        do {
            if ((pre = this.count.get()) > 0) continue;
            throw new IllegalStateException("Illegal count: " + pre);
        } while (!this.count.compareAndSet(pre, pre - 1));
    }

    boolean tryDispose() {
        return this.count.get() == -1 || this.count.compareAndSet(0, -1);
    }

    public int get() {
        return this.count.get();
    }
}

