/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.function.Supplier;
import org.neo4j.causalclustering.ReplicationModule;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.IdentityModule;
import org.neo4j.causalclustering.core.LeaderCanWrite;
import org.neo4j.causalclustering.core.consensus.ConsensusModule;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.server.CoreServerModule;
import org.neo4j.causalclustering.core.state.ClusteringModule;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachinesModule;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.procedures.ClusterOverviewProcedure;
import org.neo4j.causalclustering.discovery.procedures.CoreRoleProcedure;
import org.neo4j.causalclustering.discovery.procedures.GetServersProcedure;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.logging.BetterMessageLogger;
import org.neo4j.causalclustering.logging.MessageLogger;
import org.neo4j.causalclustering.logging.NullMessageLogger;
import org.neo4j.causalclustering.messaging.CoreReplicatedContentMarshal;
import org.neo4j.causalclustering.messaging.LoggingOutbound;
import org.neo4j.causalclustering.messaging.RaftChannelInitializer;
import org.neo4j.causalclustering.messaging.RaftOutbound;
import org.neo4j.causalclustering.messaging.SenderService;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.enterprise.builtinprocs.EnterpriseBuiltInDbmsProcedures;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.index.RemoveOrphanConstraintIndexesOnStartup;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.enterprise.EnterpriseConstraintSemantics;
import org.neo4j.kernel.impl.enterprise.EnterpriseEditionModule;
import org.neo4j.kernel.impl.enterprise.StandardBoltConnectionTracker;
import org.neo4j.kernel.impl.enterprise.transaction.log.checkpoint.ConfigurableIOLimiter;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.factory.StatementLocksFactorySelector;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.DefaultKernelData;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.udc.UsageData;

public class EnterpriseCoreEditionModule
extends EditionModule {
    public static final String CLUSTER_STATE_DIRECTORY_NAME = "cluster-state";
    private final ConsensusModule consensusModule;
    private final CoreTopologyService topologyService;
    private final LogProvider logProvider;
    private final Config config;

    public void registerEditionSpecificProcedures(Procedures procedures) throws KernelException {
        procedures.registerProcedure(EnterpriseBuiltInDbmsProcedures.class, true);
        procedures.register((CallableProcedure)new GetServersProcedure(this.topologyService, this.consensusModule.raftMachine(), this.config, this.logProvider));
        procedures.register((CallableProcedure)new ClusterOverviewProcedure(this.topologyService, this.consensusModule.raftMachine(), this.logProvider));
        procedures.register((CallableProcedure)new CoreRoleProcedure(this.consensusModule.raftMachine()));
    }

    EnterpriseCoreEditionModule(PlatformModule platformModule, DiscoveryServiceFactory discoveryServiceFactory) {
        Dependencies dependencies = platformModule.dependencies;
        this.config = platformModule.config;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        File storeDir = platformModule.storeDir;
        File clusterStateDirectory = this.createClusterStateDirectory(storeDir, fileSystem);
        LifeSupport life = platformModule.life;
        Monitors monitors = platformModule.monitors;
        this.eligibleForIdReuse = IdReuseEligibility.ALWAYS;
        this.logProvider = logging.getInternalLogProvider();
        Supplier databaseHealthSupplier = dependencies.provideDependency(DatabaseHealth.class);
        LocalDatabase localDatabase = new LocalDatabase(platformModule.storeDir, new StoreFiles(fileSystem), platformModule.dataSourceManager, platformModule.pageCache, fileSystem, databaseHealthSupplier, this.logProvider);
        IdentityModule identityModule = new IdentityModule(platformModule, clusterStateDirectory);
        ClusteringModule clusteringModule = new ClusteringModule(discoveryServiceFactory, identityModule.myself(), platformModule, clusterStateDirectory);
        this.topologyService = clusteringModule.topologyService();
        long logThresholdMillis = (Long)this.config.get(CausalClusteringSettings.unknown_address_logging_throttle);
        int maxQueueSize = (Integer)this.config.get(CausalClusteringSettings.outgoing_queue_size);
        SenderService raftSender = new SenderService(new RaftChannelInitializer(new CoreReplicatedContentMarshal(), this.logProvider, monitors), this.logProvider, platformModule.monitors, maxQueueSize);
        life.add((Lifecycle)raftSender);
        MessageLogger<MemberId> messageLogger = this.createMessageLogger(this.config, life, identityModule.myself());
        RaftOutbound raftOutbound = new RaftOutbound(this.topologyService, raftSender, clusteringModule.clusterIdentity(), this.logProvider, logThresholdMillis);
        LoggingOutbound<MemberId, RaftMessages.RaftMessage> loggingOutbound = new LoggingOutbound<MemberId, RaftMessages.RaftMessage>(raftOutbound, identityModule.myself(), messageLogger);
        this.consensusModule = new ConsensusModule(identityModule.myself(), platformModule, loggingOutbound, clusterStateDirectory, this.topologyService);
        dependencies.satisfyDependency((Object)this.consensusModule.raftMachine());
        ReplicationModule replicationModule = new ReplicationModule(identityModule.myself(), platformModule, this.config, this.consensusModule, loggingOutbound, clusterStateDirectory, fileSystem, this.logProvider);
        CoreStateMachinesModule coreStateMachinesModule = new CoreStateMachinesModule(identityModule.myself(), platformModule, clusterStateDirectory, this.config, replicationModule.getReplicator(), this.consensusModule.raftMachine(), dependencies, localDatabase);
        this.idGeneratorFactory = coreStateMachinesModule.idGeneratorFactory;
        this.idTypeConfigurationProvider = coreStateMachinesModule.idTypeConfigurationProvider;
        this.labelTokenHolder = coreStateMachinesModule.labelTokenHolder;
        this.propertyKeyTokenHolder = coreStateMachinesModule.propertyKeyTokenHolder;
        this.relationshipTypeTokenHolder = coreStateMachinesModule.relationshipTypeTokenHolder;
        this.lockManager = coreStateMachinesModule.lockManager;
        this.commitProcessFactory = coreStateMachinesModule.commitProcessFactory;
        this.accessCapability = new LeaderCanWrite(this.consensusModule.raftMachine());
        CoreServerModule coreServerModule = new CoreServerModule(identityModule, platformModule, this.consensusModule, coreStateMachinesModule, replicationModule, clusterStateDirectory, clusteringModule, localDatabase, messageLogger, databaseHealthSupplier);
        this.editionInvariants(platformModule, dependencies, this.config, logging, life);
        dependencies.satisfyDependency((Object)this.lockManager);
        life.add(this.consensusModule.raftTimeoutService());
        life.add((Lifecycle)coreServerModule.membershipWaiterLifecycle);
    }

    private MessageLogger<MemberId> createMessageLogger(Config config, LifeSupport life, MemberId myself) {
        MessageLogger<MemberId> messageLogger;
        if (((Boolean)config.get(CausalClusteringSettings.raft_messages_log_enable)).booleanValue()) {
            File logsDir = (File)config.get(GraphDatabaseSettings.logs_directory);
            messageLogger = (MessageLogger)life.add(new BetterMessageLogger<MemberId>(myself, EnterpriseCoreEditionModule.raftMessagesLog(logsDir)));
        } else {
            messageLogger = new NullMessageLogger<MemberId>();
        }
        return messageLogger;
    }

    private void editionInvariants(PlatformModule platformModule, Dependencies dependencies, Config config, LogService logging, LifeSupport life) {
        this.statementLocksFactory = new StatementLocksFactorySelector(this.lockManager, config, logging).select();
        dependencies.satisfyDependency((Object)this.createKernelData(platformModule.fileSystem, platformModule.pageCache, platformModule.storeDir, config, (GraphDatabaseAPI)platformModule.graphDatabaseFacade, life));
        this.ioLimiter = new ConfigurableIOLimiter(platformModule.config);
        this.headerInformationFactory = this.createHeaderInformationFactory();
        this.schemaWriteGuard = this.createSchemaWriteGuard();
        this.transactionStartTimeout = (Long)config.get(GraphDatabaseSettings.transaction_start_timeout);
        this.constraintSemantics = new EnterpriseConstraintSemantics();
        this.coreAPIAvailabilityGuard = new CoreAPIAvailabilityGuard(platformModule.availabilityGuard, this.transactionStartTimeout);
        this.registerRecovery(platformModule.databaseInfo, life, (DependencyResolver)dependencies);
        this.publishEditionInfo((UsageData)dependencies.resolveDependency(UsageData.class), platformModule.databaseInfo, config);
        dependencies.satisfyDependency((Object)this.createSessionTracker());
    }

    public boolean isLeader() {
        return this.consensusModule.raftMachine().currentRole() == Role.LEADER;
    }

    private File createClusterStateDirectory(File dir, FileSystemAbstraction fileSystem) {
        File raftLogDir = new File(dir, CLUSTER_STATE_DIRECTORY_NAME);
        try {
            fileSystem.mkdirs(raftLogDir);
            return raftLogDir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static PrintWriter raftMessagesLog(File logsDir) {
        logsDir.mkdirs();
        try {
            return new PrintWriter(new FileOutputStream(new File(logsDir, "raft-messages.log"), true));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private SchemaWriteGuard createSchemaWriteGuard() {
        return () -> {};
    }

    private KernelData createKernelData(FileSystemAbstraction fileSystem, PageCache pageCache, File storeDir, Config config, GraphDatabaseAPI graphAPI, LifeSupport life) {
        DefaultKernelData kernelData = new DefaultKernelData(fileSystem, pageCache, storeDir, config, graphAPI);
        return (KernelData)life.add((Lifecycle)kernelData);
    }

    private TransactionHeaderInformationFactory createHeaderInformationFactory() {
        return () -> new TransactionHeaderInformation(-1, -1, new byte[0]);
    }

    private void registerRecovery(DatabaseInfo databaseInfo, LifeSupport life, DependencyResolver dependencyResolver) {
        life.addLifecycleListener((instance, from, to) -> {
            if (instance instanceof DatabaseAvailability && LifecycleStatus.STARTED.equals((Object)to)) {
                this.doAfterRecoveryAndStartup(databaseInfo, dependencyResolver);
            }
        });
    }

    protected void doAfterRecoveryAndStartup(DatabaseInfo databaseInfo, DependencyResolver dependencyResolver) {
        super.doAfterRecoveryAndStartup(databaseInfo, dependencyResolver);
        if (((RaftMachine)dependencyResolver.resolveDependency(RaftMachine.class)).isLeader()) {
            new RemoveOrphanConstraintIndexesOnStartup(((NeoStoreDataSource)dependencyResolver.resolveDependency(NeoStoreDataSource.class)).getKernel(), ((LogService)dependencyResolver.resolveDependency(LogService.class)).getInternalLogProvider()).perform();
        }
    }

    protected BoltConnectionTracker createSessionTracker() {
        return new StandardBoltConnectionTracker();
    }

    public void setupSecurityModule(PlatformModule platformModule, Procedures procedures) {
        EnterpriseEditionModule.setupEnterpriseSecurityModule((PlatformModule)platformModule, (Procedures)procedures);
    }

    public static enum RaftLogImplementation {
        IN_MEMORY,
        SEGMENTED;

    }
}

