/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class LocalDatabase
implements Lifecycle {
    private final File storeDir;
    private final StoreFiles storeFiles;
    private final DataSourceManager dataSourceManager;
    private final PageCache pageCache;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final Supplier<DatabaseHealth> databaseHealthSupplier;
    private final Log log;
    private volatile StoreId storeId;
    private volatile DatabaseHealth databaseHealth;
    private boolean started = false;

    public LocalDatabase(File storeDir, StoreFiles storeFiles, DataSourceManager dataSourceManager, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, Supplier<DatabaseHealth> databaseHealthSupplier, LogProvider logProvider) {
        this.storeDir = storeDir;
        this.storeFiles = storeFiles;
        this.dataSourceManager = dataSourceManager;
        this.pageCache = pageCache;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.databaseHealthSupplier = databaseHealthSupplier;
        this.log = logProvider.getLog(this.getClass());
    }

    public void init() throws Throwable {
        this.dataSourceManager.init();
    }

    public synchronized void start() throws Throwable {
        this.storeId = this.readStoreIdFromDisk();
        this.log.info("Starting with storeId: " + this.storeId);
        this.dataSourceManager.start();
        this.started = true;
    }

    public synchronized void stop() throws Throwable {
        this.log.info("Stopping");
        this.databaseHealth = null;
        this.dataSourceManager.stop();
        this.started = false;
    }

    public boolean isAvailable() {
        return this.started;
    }

    public void shutdown() throws Throwable {
        this.dataSourceManager.shutdown();
    }

    public synchronized StoreId storeId() {
        if (this.started) {
            return this.storeId;
        }
        return this.readStoreIdFromDisk();
    }

    private StoreId readStoreIdFromDisk() {
        try {
            File neoStoreFile = new File(this.storeDir, "neostore");
            org.neo4j.kernel.impl.store.StoreId kernelStoreId = MetaDataStore.getStoreId((PageCache)this.pageCache, (File)neoStoreFile);
            return new StoreId(kernelStoreId.getCreationTime(), kernelStoreId.getRandomId(), kernelStoreId.getUpgradeTime(), kernelStoreId.getUpgradeId());
        }
        catch (IOException e) {
            this.log.error("Failure reading store id", (Throwable)e);
            return null;
        }
    }

    public void panic(Throwable cause) {
        this.getDatabaseHealth().panic(cause);
    }

    public <EXCEPTION extends Throwable> void assertHealthy(Class<EXCEPTION> cause) throws EXCEPTION {
        this.getDatabaseHealth().assertHealthy(cause);
    }

    private DatabaseHealth getDatabaseHealth() {
        if (this.databaseHealth == null) {
            this.databaseHealth = this.databaseHealthSupplier.get();
        }
        return this.databaseHealth;
    }

    public void delete() throws IOException {
        this.storeFiles.delete(this.storeDir);
    }

    public boolean isEmpty() throws IOException {
        return !this.hasStoreFiles();
    }

    private boolean hasStoreFiles() {
        for (StoreType storeType : StoreType.values()) {
            boolean exists;
            StoreFile storeFile = storeType.getStoreFile();
            if (storeFile == null || !(exists = this.fileSystemAbstraction.fileExists(new File(this.storeDir, storeFile.storeFileName())))) continue;
            return true;
        }
        return false;
    }

    public File storeDir() {
        return this.storeDir;
    }

    public void replaceWith(File sourceDir) throws IOException {
        this.storeFiles.delete(this.storeDir);
        this.storeFiles.moveTo(sourceDir, this.storeDir);
    }

    public NeoStoreDataSource dataSource() {
        return this.dataSourceManager.getDataSource();
    }
}

