/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.causalclustering.catchup.storecopy.FileChunk;
import org.neo4j.io.fs.StoreChannel;

class FileSender
implements ChunkedInput<FileChunk> {
    private final StoreChannel channel;
    private final ByteBuffer byteBuffer;
    private boolean endOfInput = false;
    private boolean sentChunk = false;
    private byte[] preFetchedBytes;

    public FileSender(StoreChannel channel) throws IOException {
        this.channel = channel;
        this.byteBuffer = ByteBuffer.allocateDirect(8192);
        this.preFetchedBytes = this.prefetch();
    }

    public boolean isEndOfInput() throws Exception {
        return this.endOfInput && this.preFetchedBytes == null && this.sentChunk;
    }

    public void close() throws Exception {
        this.channel.close();
    }

    public FileChunk readChunk(ByteBufAllocator allocator) throws Exception {
        if (this.isEndOfInput()) {
            return null;
        }
        this.sentChunk = true;
        byte[] next = this.prefetch();
        FileChunk fileChunk = FileChunk.create(this.preFetchedBytes == null ? new byte[]{} : this.preFetchedBytes, next == null);
        this.preFetchedBytes = next;
        return fileChunk;
    }

    public FileChunk readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    public long length() {
        return -1L;
    }

    public long progress() {
        return 0L;
    }

    private byte[] prefetch() throws IOException {
        int bytesRead = this.channel.read(this.byteBuffer);
        if (bytesRead == -1) {
            this.endOfInput = true;
            return null;
        }
        return this.createByteArray(this.byteBuffer);
    }

    private byte[] createByteArray(ByteBuffer buffer) {
        buffer.flip();
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        buffer.clear();
        return bytes;
    }
}

