/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.neo4j.helpers.AdvertisedSocketAddress;

class CatchUpChannelPool<CHANNEL extends Channel> {
    private final Map<AdvertisedSocketAddress, LinkedList<CHANNEL>> idleChannels = new HashMap<AdvertisedSocketAddress, LinkedList<CHANNEL>>();
    private final Set<CHANNEL> activeChannels = new HashSet<CHANNEL>();
    private final Function<AdvertisedSocketAddress, CHANNEL> factory;

    CatchUpChannelPool(Function<AdvertisedSocketAddress, CHANNEL> factory) {
        this.factory = factory;
    }

    synchronized CHANNEL acquire(AdvertisedSocketAddress catchUpAddress) {
        Channel channel;
        LinkedList<CHANNEL> channels = this.idleChannels.get(catchUpAddress);
        if (channels == null) {
            channel = (Channel)this.factory.apply(catchUpAddress);
        } else {
            channel = (Channel)channels.poll();
            if (channels.isEmpty()) {
                this.idleChannels.remove(catchUpAddress);
            }
        }
        this.activeChannels.add(channel);
        return (CHANNEL)channel;
    }

    synchronized void dispose(CHANNEL channel) {
        this.activeChannels.remove(channel);
        channel.close();
    }

    synchronized void release(CHANNEL channel) {
        this.activeChannels.remove(channel);
        this.idleChannels.computeIfAbsent(channel.destination(), address -> new LinkedList()).add(channel);
    }

    synchronized void close() {
        this.idleChannels.values().stream().flatMap(Collection::stream).forEach(Channel::close);
        this.activeChannels.forEach(Channel::close);
    }

    static interface Channel {
        public AdvertisedSocketAddress destination();

        public void close();
    }
}

