/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.commandline.dbms.UnbindFromClusterCommand;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class UnbindFromClusterCommandTest {
    private final TestDirectory testDir = TestDirectory.testDirectory();
    private final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.testDir);

    @Test
    public void shouldFailIfSpecifiedDatabaseDoesNotExist() throws Exception {
        EphemeralFileSystemAbstraction fsa = this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        UnbindFromClusterCommand command = new UnbindFromClusterCommand(this.testDir.directory().toPath(), this.testDir.directory("conf").toPath(), (OutsideWorld)Mockito.mock(OutsideWorld.class));
        try {
            command.execute(this.nonExistentDatabaseArg());
            TestCase.fail();
        }
        catch (IncorrectUsage e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"does not contain a database"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFailToUnbindLiveDatabase() throws Exception {
        try (DefaultFileSystemAbstraction fsa = new DefaultFileSystemAbstraction();){
            fsa.mkdir(this.testDir.directory());
            UnbindFromClusterCommand command = new UnbindFromClusterCommand(this.testDir.directory().toPath(), this.testDir.directory("conf").toPath(), (OutsideWorld)Mockito.mock(OutsideWorld.class));
            FileLock fileLock = this.createLockedFakeDbDir(this.testDir.directory().toPath());
            try {
                command.execute(this.databaseName("graph.db"));
                TestCase.fail();
            }
            catch (CommandFailed e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Database is currently locked. Please shutdown Neo4j."));
            }
            finally {
                fileLock.release();
            }
        }
    }

    @Test
    public void shouldRemoveClusterStateDirectoryForGivenDatabase() throws Exception {
        int numberOfFilesAndDirsInANormalNeo4jStoreDir = 35;
        EphemeralFileSystemAbstraction fsa = this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        Path fakeDbDir = this.createUnlockedFakeDbDir(this.testDir.directory().toPath());
        UnbindFromClusterCommand command = new UnbindFromClusterCommand(this.testDir.directory().toPath(), this.testDir.directory("conf").toPath(), (OutsideWorld)Mockito.mock(OutsideWorld.class));
        command.execute(this.databaseName("graph.db"));
        Assert.assertEquals((long)35L, (long)Files.list(fakeDbDir).toArray().length);
    }

    @Test
    public void shouldReportWhenClusterStateDirectoryIsNotPresent() throws Exception {
        EphemeralFileSystemAbstraction fsa = this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        Path fakeDbDir = this.createUnlockedFakeDbDir(this.testDir.directory().toPath());
        Files.delete(Paths.get(fakeDbDir.toString(), "cluster-state"));
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        UnbindFromClusterCommand command = new UnbindFromClusterCommand(this.testDir.directory().toPath(), this.testDir.directory("conf").toPath(), outsideWorld);
        command.execute(this.databaseName("graph.db"));
        ((OutsideWorld)Mockito.verify((Object)outsideWorld)).stdErrLine(org.mockito.Matchers.startsWith((String)"No cluster state found in"));
    }

    @Test
    public void shouldPrintNiceHelp() throws Throwable {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
            usage.printUsageForCommand((AdminCommand.Provider)new UnbindFromClusterCommand.Provider(), ps::println);
            Assert.assertEquals((Object)String.format("usage: neo4j-admin unbind [--database=<name>]%n%nRemoves cluster state data from the specified database making it suitable for%nuse in single instance database, or for seeding a new cluster.%n%noptions:%n  --database=<name>   Name of database. [default:graph.db]%n", new Object[0]), (Object)baos.toString());
        }
    }

    private String[] databaseName(String databaseName) {
        return new String[]{"--database=" + databaseName};
    }

    private Path createUnlockedFakeDbDir(Path parent) throws IOException {
        Path fakeDbDir = this.createFakeDbDir(parent);
        Files.createFile(Paths.get(fakeDbDir.toString(), "store_lock"), new FileAttribute[0]);
        return fakeDbDir;
    }

    private FileLock createLockedFakeDbDir(Path parent) throws IOException {
        return this.createLockedStoreLockFileIn(this.createFakeDbDir(parent));
    }

    private Path createFakeDbDir(Path parent) throws IOException {
        Path data = this.createDirectory(parent, "data");
        Path database = this.createDirectory(data, "databases");
        Path graph_db = this.createDirectory(database, "graph.db");
        this.createDirectory(graph_db, "cluster-state");
        this.createDirectory(graph_db, "schema");
        this.createDirectory(graph_db, "index");
        this.createFile(graph_db, "neostore");
        this.createFile(graph_db, "neostore.counts.db.a");
        this.createFile(graph_db, "neostore.id");
        this.createFile(graph_db, "neostore.labeltokenstore.db");
        this.createFile(graph_db, "neostore.labeltokenstore.db.id");
        this.createFile(graph_db, "neostore.labeltokenstore.db.names");
        this.createFile(graph_db, "neostore.labeltokenstore.db.names.id");
        this.createFile(graph_db, "neostore.nodestore.db");
        this.createFile(graph_db, "neostore.nodestore.db.id");
        this.createFile(graph_db, "neostore.nodestore.db.labels");
        this.createFile(graph_db, "neostore.nodestore.db.labels.id");
        this.createFile(graph_db, "neostore.propertystore.db");
        this.createFile(graph_db, "neostore.propertystore.db.arrays");
        this.createFile(graph_db, "neostore.propertystore.db.arrays.id");
        this.createFile(graph_db, "neostore.propertystore.db.id");
        this.createFile(graph_db, "neostore.propertystore.db.index");
        this.createFile(graph_db, "neostore.propertystore.db.index.id");
        this.createFile(graph_db, "neostore.propertystore.db.index.keys");
        this.createFile(graph_db, "neostore.propertystore.db.index.keys.id");
        this.createFile(graph_db, "neostore.propertystore.db.strings");
        this.createFile(graph_db, "neostore.propertystore.db.strings.id");
        this.createFile(graph_db, "neostore.relationshipgroupstore.db");
        this.createFile(graph_db, "neostore.relationshipgroupstore.db.id");
        this.createFile(graph_db, "neostore.relationshipstore.db");
        this.createFile(graph_db, "neostore.relationshipstore.db.id");
        this.createFile(graph_db, "neostore.relationshiptypestore.db");
        this.createFile(graph_db, "neostore.relationshiptypestore.db.id");
        this.createFile(graph_db, "neostore.relationshiptypestore.db.names");
        this.createFile(graph_db, "neostore.relationshiptypestore.db.names.id");
        this.createFile(graph_db, "neostore.schemastore.db");
        this.createFile(graph_db, "neostore.schemastore.db.id");
        this.createFile(graph_db, "neostore.transaction.db.0");
        return graph_db;
    }

    private Path createFile(Path parent, String file) throws IOException {
        return Files.createFile(Paths.get(parent.toString(), file), new FileAttribute[0]);
    }

    private Path createDirectory(Path parent, String subDir) throws IOException {
        return Files.createDirectory(Paths.get(parent.toString(), subDir), new FileAttribute[0]);
    }

    private FileLock createLockedStoreLockFileIn(Path parent) throws IOException {
        Path storeLockFile = Files.createFile(Paths.get(parent.toString(), "store_lock"), new FileAttribute[0]);
        FileChannel channel = FileChannel.open(storeLockFile, StandardOpenOption.READ, StandardOpenOption.WRITE);
        return channel.lock(0L, Long.MAX_VALUE, true);
    }

    private String[] nonExistentDatabaseArg() {
        return new String[]{"--database=" + UUID.randomUUID().toString()};
    }

    private String[] noArgs() {
        return new String[0];
    }
}

