/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.test.causalclustering.ClusterRule;

public class RestartIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass()).withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);

    @Test
    public void restartFirstServer() throws Exception {
        Cluster cluster = this.clusterRule.startCluster();
        cluster.removeCoreMemberWithMemberId(0);
        cluster.addCoreMemberWithId(0);
        cluster.shutdown();
    }

    @Test
    public void restartSecondServer() throws Exception {
        Cluster cluster = this.clusterRule.startCluster();
        cluster.removeCoreMemberWithMemberId(1);
        cluster.addCoreMemberWithId(1);
        cluster.shutdown();
    }

    @Test
    public void restartWhileDoingTransactions() throws Exception {
        Cluster cluster = this.clusterRule.startCluster();
        CoreGraphDatabase coreDB = cluster.getCoreMemberById(0).database();
        ExecutorService executor = Executors.newCachedThreadPool();
        AtomicBoolean done = new AtomicBoolean(false);
        executor.execute(() -> RestartIT.lambda$restartWhileDoingTransactions$0(done, (GraphDatabaseService)coreDB));
        Thread.sleep(500L);
        cluster.removeCoreMemberWithMemberId(1);
        cluster.addCoreMemberWithId(1);
        Thread.sleep(500L);
        done.set(true);
        executor.shutdown();
    }

    @Test
    public void shouldHaveWritableClusterAfterCompleteRestart() throws Exception {
        Cluster cluster = this.clusterRule.startCluster();
        cluster.shutdown();
        cluster.start();
        CoreClusterMember last = cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        Cluster.dataMatchesEventually(last, cluster.coreMembers());
        cluster.shutdown();
    }

    @Test
    public void readReplicaTest() throws Exception {
        Cluster cluster = this.clusterRule.withNumberOfCoreMembers(2).withNumberOfReadReplicas(1).startCluster();
        CoreGraphDatabase coreDB = cluster.awaitLeader(5L, TimeUnit.SECONDS).database();
        try (Transaction tx = coreDB.beginTx();){
            Node node = coreDB.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        }
        cluster.addCoreMemberWithId(2).start();
        cluster.shutdown();
        var4_4 = null;
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            ConsistencyCheckService.Result result;
            for (CoreClusterMember core : cluster.coreMembers()) {
                result = new ConsistencyCheckService().runFullConsistencyCheck(core.storeDir(), Config.defaults(), ProgressMonitorFactory.NONE, (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out), (FileSystemAbstraction)fileSystem, false);
                Assert.assertTrue((String)("Inconsistent: " + core), (boolean)result.isSuccessful());
            }
            for (ReadReplica readReplica : cluster.readReplicas()) {
                result = new ConsistencyCheckService().runFullConsistencyCheck(readReplica.storeDir(), Config.defaults(), ProgressMonitorFactory.NONE, (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out), (FileSystemAbstraction)fileSystem, false);
                Assert.assertTrue((String)("Inconsistent: " + readReplica), (boolean)result.isSuccessful());
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    private static /* synthetic */ void lambda$restartWhileDoingTransactions$0(AtomicBoolean done, GraphDatabaseService coreDB) {
        while (!done.get()) {
            try {
                Transaction tx = coreDB.beginTx();
                Throwable throwable = null;
                try {
                    Node node = coreDB.createNode(new Label[]{Label.label((String)"boo")});
                    node.setProperty("foobar", (Object)"baz_bat");
                    tx.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            catch (WriteOperationsNotAllowedException | AcquireLockTimeoutException throwable) {}
        }
    }
}

