/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.test.causalclustering.ClusterRule;

public class CoreReplicationIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass()).withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);
    private Cluster cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void shouldReplicateTransactionsToCoreMembers() throws Exception {
        CoreClusterMember leader = this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        Assert.assertEquals((long)1L, (long)this.countNodes(leader));
        Cluster.dataMatchesEventually(leader, this.cluster.coreMembers());
    }

    @Test
    public void shouldNotAllowWritesFromAFollower() throws Exception {
        this.cluster.awaitLeader();
        CoreGraphDatabase follower = this.cluster.getDbWithRole(Role.FOLLOWER).database();
        try (Transaction tx = follower.beginTx();){
            follower.createNode();
            tx.success();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (WriteOperationsNotAllowedException ignored) {
            Assert.assertThat((Object)ignored.getMessage(), (Matcher)CoreMatchers.containsString((String)"No write operations are allowed"));
        }
    }

    @Test
    public void shouldNotAllowSchemaChangesFromAFollower() throws Exception {
        this.cluster.awaitLeader();
        CoreGraphDatabase follower = this.cluster.getDbWithRole(Role.FOLLOWER).database();
        try (Transaction tx = follower.beginTx();){
            follower.schema().constraintFor(Label.label((String)"Foo")).assertPropertyIsUnique("name").create();
            tx.success();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (WriteOperationsNotAllowedException ignored) {
            Assert.assertThat((Object)ignored.getMessage(), (Matcher)CoreMatchers.containsString((String)"No write operations are allowed"));
        }
    }

    @Test
    public void shouldNotAllowTokenCreationFromAFollowerWithNoInitialTokens() throws Exception {
        CoreClusterMember leader = this.cluster.coreTx((db, tx) -> {
            db.createNode();
            tx.success();
        });
        this.awaitForDataToBeApplied(leader);
        Cluster.dataMatchesEventually(leader, this.cluster.coreMembers());
        CoreGraphDatabase follower = this.cluster.getDbWithRole(Role.FOLLOWER).database();
        try (Transaction tx2 = follower.beginTx();){
            ((Node)follower.getAllNodes().iterator().next()).setProperty("name", (Object)"Mark");
            tx2.success();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (WriteOperationsNotAllowedException ignored) {
            Assert.assertThat((Object)ignored.getMessage(), (Matcher)CoreMatchers.containsString((String)"No write operations are allowed"));
        }
    }

    private void awaitForDataToBeApplied(CoreClusterMember leader) throws InterruptedException, TimeoutException {
        Predicates.await(() -> this.countNodes(leader) > 0L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public void shouldReplicateTransactionToCoreMemberAddedAfterInitialStartUp() throws Exception {
        this.cluster.addCoreMemberWithId(3).start();
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode();
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        this.cluster.addCoreMemberWithId(4).start();
        CoreClusterMember last = this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode();
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        Assert.assertEquals((long)2L, (long)this.countNodes(last));
        Cluster.dataMatchesEventually(last, this.cluster.coreMembers());
    }

    @Test
    public void shouldReplicateTransactionAfterLeaderWasRemovedFromCluster() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode();
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        this.cluster.removeCoreMember(this.cluster.awaitLeader());
        this.cluster.awaitLeader(1L, TimeUnit.MINUTES);
        CoreClusterMember last = this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode();
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        Assert.assertEquals((long)2L, (long)this.countNodes(last));
        Cluster.dataMatchesEventually(last, this.cluster.coreMembers());
    }

    @Test
    public void shouldReplicateToCoreMembersAddedAfterInitialTransactions() throws Exception {
        CoreClusterMember last = null;
        for (int i = 0; i < 15; ++i) {
            last = this.cluster.coreTx((db, tx) -> {
                Node node = db.createNode();
                node.setProperty("foobar", (Object)"baz_bat");
                tx.success();
            });
        }
        this.cluster.addCoreMemberWithId(3).start();
        this.cluster.addCoreMemberWithId(4).start();
        Assert.assertEquals((long)15L, (long)this.countNodes(last));
        Cluster.dataMatchesEventually(last, this.cluster.coreMembers());
    }

    @Test
    public void shouldReplicateTransactionsToReplacementCoreMembers() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        this.cluster.removeCoreMemberWithMemberId(0);
        CoreClusterMember replacement = this.cluster.addCoreMemberWithId(0);
        replacement.start();
        CoreClusterMember leader = this.cluster.coreTx((db, tx) -> {
            db.schema().indexFor(Label.label((String)"boo")).on("foobar").create();
            tx.success();
        });
        Assert.assertEquals((long)1L, (long)this.countNodes(leader));
        Cluster.dataMatchesEventually(leader, this.cluster.coreMembers());
    }

    @Test
    public void shouldBeAbleToShutdownWhenTheLeaderIsTryingToReplicateTransaction() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        final CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    CoreReplicationIT.this.cluster.coreTx((db, tx) -> {
                        db.createNode();
                        tx.success();
                        CoreReplicationIT.this.cluster.removeCoreMember(CoreReplicationIT.this.cluster.getDbWithAnyRole(Role.FOLLOWER, Role.CANDIDATE));
                        CoreReplicationIT.this.cluster.removeCoreMember(CoreReplicationIT.this.cluster.getDbWithAnyRole(Role.FOLLOWER, Role.CANDIDATE));
                        latch.countDown();
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        thread.start();
        latch.await();
        this.cluster.shutdown();
        thread.join(TimeUnit.MINUTES.toMillis(1L));
    }

    private long countNodes(CoreClusterMember member) {
        long count;
        CoreGraphDatabase db = member.database();
        try (Transaction tx = db.beginTx();){
            count = Iterables.count((Iterable)db.getAllNodes());
            tx.success();
        }
        return count;
    }
}

