/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.scenarios.SampleData;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.causalclustering.ClusterRule;

public class CorePruningIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass()).withNumberOfCoreMembers(3).withNumberOfReadReplicas(0).withSharedCoreParam(CausalClusteringSettings.state_machine_flush_window_size, "1").withSharedCoreParam(CausalClusteringSettings.raft_log_pruning_strategy, "keep_none").withSharedCoreParam(CausalClusteringSettings.raft_log_rotation_size, "1K").withSharedCoreParam(CausalClusteringSettings.raft_log_pruning_frequency, "100ms");

    @Test
    public void actuallyDeletesTheFiles() throws Exception {
        Cluster cluster = this.clusterRule.startCluster();
        CoreClusterMember coreGraphDatabase = null;
        int txs = 10;
        for (int i = 0; i < txs; ++i) {
            coreGraphDatabase = cluster.coreTx((db, tx) -> {
                SampleData.createData((GraphDatabaseService)db, 1);
                tx.success();
            });
        }
        File storeDir = coreGraphDatabase.storeDir();
        int expectedNumberOfLogFilesAfterPruning = 2;
        Assert.assertEventually((String)"raft logs eventually pruned", () -> this.numberOfFiles(storeDir), (Matcher)Matchers.equalTo((Object)expectedNumberOfLogFilesAfterPruning), (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public void shouldNotPruneUncommittedEntries() throws Exception {
        Cluster cluster = this.clusterRule.startCluster();
        CoreClusterMember coreGraphDatabase = null;
        int txs = 1000;
        for (int i = 0; i < txs; ++i) {
            coreGraphDatabase = cluster.coreTx((db, tx) -> SampleData.createData((GraphDatabaseService)db, 1));
        }
        File storeDir = coreGraphDatabase.storeDir();
        int expectedNumberOfLogFilesAfterPruning = 2;
        Assert.assertEventually((String)"raft logs eventually pruned", () -> this.numberOfFiles(storeDir), (Matcher)Matchers.equalTo((Object)expectedNumberOfLogFilesAfterPruning), (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    private int numberOfFiles(File storeDir) throws RuntimeException {
        File clusterDir = new File(storeDir, "cluster-state");
        File raftLogDir = new File(clusterDir, "raft-log");
        return raftLogDir.list().length;
    }
}

