/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.CatchupServer;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.state.CoreState;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.HazelcastDiscoveryServiceFactory;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.ClientConnectorSettings;
import org.neo4j.test.causalclustering.ClusterRule;

public class ConnectionInfoIT {
    private Socket testSocket;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass()).withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);

    @After
    public void teardown() throws IOException {
        if (this.testSocket != null) {
            this.unbind(this.testSocket);
        }
    }

    @Test
    public void catchupServerMessage() throws Throwable {
        this.testSocket = this.bindPort("localhost", 4242);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        AssertableLogProvider userLogProvider = new AssertableLogProvider();
        CoreState coreState = (CoreState)Mockito.mock(CoreState.class);
        Config config = Config.defaults().with(Collections.singletonMap(CausalClusteringSettings.transaction_listen_address.name(), ":" + this.testSocket.getLocalPort()), new Class[0]);
        CatchupServer catchupServer = new CatchupServer((LogProvider)logProvider, (LogProvider)userLogProvider, this.mockSupplier(), this.mockSupplier(), this.mockSupplier(), this.mockSupplier(), (BooleanSupplier)Mockito.mock(BooleanSupplier.class), coreState, config, new Monitors(), this.mockSupplier(), (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class));
        try {
            catchupServer.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logProvider.assertContainsMessageContaining("Address is already bound for setting");
        userLogProvider.assertContainsMessageContaining("Address is already bound for setting");
    }

    private <T> Supplier<T> mockSupplier() {
        return (Supplier)Mockito.mock(Supplier.class);
    }

    @Test
    public void hzTest() throws Throwable {
        this.testSocket = this.bindPort("0.0.0.0", 4243);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        AssertableLogProvider userLogProvider = new AssertableLogProvider();
        HazelcastDiscoveryServiceFactory hzFactory = new HazelcastDiscoveryServiceFactory();
        Config config = Config.defaults().with(Collections.singletonMap(CausalClusteringSettings.discovery_listen_address.name(), ":" + this.testSocket.getLocalPort()), new Class[0]);
        config.augment(Collections.singletonMap(CausalClusteringSettings.initial_discovery_members.name(), "localhost:" + this.testSocket.getLocalPort()));
        config.augment(Collections.singletonMap(GraphDatabaseSettings.boltConnector((String)"bolt").enabled.name(), "true"));
        config.augment(Collections.singletonMap(ClientConnectorSettings.httpConnector((String)"http").enabled.name(), "true"));
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        CoreTopologyService coreTopologyService = hzFactory.coreTopologyService(config, new MemberId(UUID.randomUUID()), (JobScheduler)jobScheduler, (LogProvider)logProvider, (LogProvider)userLogProvider);
        try {
            coreTopologyService.init();
            coreTopologyService.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logProvider.assertContainsMessageContaining("Hazelcast was unable to start with setting");
        userLogProvider.assertContainsMessageContaining("Hazelcast was unable to start with setting");
    }

    private Socket bindPort(String address, int port) throws IOException {
        Socket socket = new Socket();
        socket.bind(new InetSocketAddress(address, port));
        return socket;
    }

    private void unbind(Socket socket) throws IOException {
        socket.close();
    }
}

