/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HazelcastDiscoveryServiceFactory;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.causalclustering.ClusterRule;

public class ClusterMembershipChangeIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass()).withDiscoveryServiceFactory((DiscoveryServiceFactory)new HazelcastDiscoveryServiceFactory()).withNumberOfCoreMembers(3);

    @Test
    @Ignore(value="Incomplete, HC will hang waiting for others to join.")
    public void newMemberNotInInitialMembersConfig() throws Throwable {
        Cluster cluster = this.clusterRule.withNumberOfReadReplicas(0).startCluster();
        List<AdvertisedSocketAddress> onlyServerZero = Collections.singletonList(Cluster.socketAddressForServer(0));
        cluster.addCoreMemberWithIdAndInitialMembers(3, onlyServerZero).start();
        cluster.addCoreMemberWithIdAndInitialMembers(4, onlyServerZero).start();
        cluster.addCoreMemberWithIdAndInitialMembers(5, onlyServerZero).start();
        cluster.removeCoreMemberWithMemberId(0);
        cluster.removeCoreMemberWithMemberId(1);
        cluster.removeCoreMemberWithMemberId(2);
        cluster.shutdown();
        cluster.start();
        for (CoreClusterMember member : cluster.coreMembers()) {
            List<Object[]> currentMembers = this.discoverClusterMembers((GraphDatabaseFacade)member.database());
            MatcherAssert.assertThat(currentMembers, (Matcher)Matchers.containsInAnyOrder((Object[])new Object[][]{{"127.0.0.1:8003"}, {"127.0.0.1:8004"}, {"127.0.0.1:8005"}}));
        }
    }

    private List<Object[]> discoverClusterMembers(GraphDatabaseFacade db) throws TransactionFailureException, ProcedureException {
        KernelAPI kernel = (KernelAPI)db.getDependencyResolver().resolveDependency(KernelAPI.class);
        KernelTransaction transaction = kernel.newTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());
        Statement statement = transaction.acquireStatement();
        return Iterators.asList((RawIterator)statement.procedureCallOperations().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"dbms", "cluster", "getServers"}), new Object[0]));
    }
}

