/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.test.causalclustering.ClusterRule;

public class ClusterFormationIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass()).withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);
    private Cluster cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void shouldSupportBuiltInProcedures() throws Exception {
        this.cluster.addReadReplicaWithId(0).start();
        Stream.concat(this.cluster.readReplicas().stream().map(ReadReplica::database), this.cluster.coreMembers().stream().map(CoreClusterMember::database)).forEach(gdb -> {
            Result result = gdb.execute("CALL dbms.procedures()");
            Assert.assertTrue((boolean)result.hasNext());
            result.close();
            try (InternalTransaction tx = gdb.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)EnterpriseSecurityContext.AUTH_DISABLED);){
                Result result2 = gdb.execute(tx, "CALL dbms.listQueries()", Collections.emptyMap());
                Assert.assertTrue((boolean)result2.hasNext());
                result2.close();
                tx.success();
            }
        });
    }

    @Test
    public void shouldBeAbleToAddAndRemoveCoreMembers() throws Exception {
        this.cluster.getCoreMemberById(0).shutdown();
        this.cluster.getCoreMemberById(0).start();
        Assert.assertEquals((long)3L, (long)this.cluster.numberOfCoreMembersReportedByTopology());
        this.cluster.removeCoreMemberWithMemberId(1);
        Assert.assertEquals((long)2L, (long)this.cluster.numberOfCoreMembersReportedByTopology());
        this.cluster.addCoreMemberWithId(4).start();
        Assert.assertEquals((long)3L, (long)this.cluster.numberOfCoreMembersReportedByTopology());
    }

    @Test
    public void shouldBeAbleToAddAndRemoveCoreMembersUnderModestLoad() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> {
            CoreGraphDatabase leader = this.cluster.getDbWithRole(Role.LEADER).database();
            try (Transaction tx = leader.beginTx();){
                leader.createNode();
                tx.success();
            }
        });
        this.cluster.getCoreMemberById(0).shutdown();
        this.cluster.getCoreMemberById(0).start();
        Assert.assertEquals((long)3L, (long)this.cluster.numberOfCoreMembersReportedByTopology());
        this.cluster.removeCoreMemberWithMemberId(0);
        Assert.assertEquals((long)2L, (long)this.cluster.numberOfCoreMembersReportedByTopology());
        this.cluster.addCoreMemberWithId(4).start();
        Assert.assertEquals((long)3L, (long)this.cluster.numberOfCoreMembersReportedByTopology());
        executorService.shutdown();
    }

    @Test
    public void shouldBeAbleToRestartTheCluster() throws Exception {
        Assert.assertEquals((long)3L, (long)this.cluster.numberOfCoreMembersReportedByTopology());
        this.cluster.shutdown();
        this.cluster.start();
        Assert.assertEquals((long)3L, (long)this.cluster.numberOfCoreMembersReportedByTopology());
        this.cluster.removeCoreMemberWithMemberId(1);
        this.cluster.addCoreMemberWithId(3).start();
        this.cluster.shutdown();
        this.cluster.start();
        Assert.assertEquals((long)3L, (long)this.cluster.numberOfCoreMembersReportedByTopology());
    }
}

