/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.catchup.tx.CatchupPollingProcess;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.txtracking.TransactionIdTracker;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.causalclustering.ClusterRule;

public class CausalConsistencyIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule(CausalConsistencyIT.class).withNumberOfCoreMembers(3).withNumberOfReadReplicas(1);

    @Test
    public void transactionsCommittedInTheCoreShouldAppearOnTheReadReplica() throws Exception {
        Cluster cluster = this.clusterRule.startCluster();
        cluster.coreTx((coreGraphDatabase, transaction) -> {
            coreGraphDatabase.createNode();
            transaction.success();
        });
        CoreGraphDatabase leaderDatabase = cluster.awaitLeader().database();
        long transactionVisibleOnLeader = this.transactionIdTracker((GraphDatabaseAPI)leaderDatabase).newestEncounteredTxId();
        ReadReplicaGraphDatabase readReplicaGraphDatabase = cluster.findAnyReadReplica().database();
        this.transactionIdTracker((GraphDatabaseAPI)readReplicaGraphDatabase).awaitUpToDate(transactionVisibleOnLeader, Duration.ofSeconds(3L));
    }

    @Test
    public void transactionsShouldNotAppearOnTheReadReplicaWhilePollingIsPaused() throws Throwable {
        Cluster cluster = this.clusterRule.startCluster();
        ReadReplicaGraphDatabase readReplicaGraphDatabase = cluster.findAnyReadReplica().database();
        CatchupPollingProcess pollingClient = (CatchupPollingProcess)readReplicaGraphDatabase.getDependencyResolver().resolveDependency(CatchupPollingProcess.class);
        pollingClient.stop();
        cluster.coreTx((coreGraphDatabase, transaction) -> {
            coreGraphDatabase.createNode();
            transaction.success();
        });
        CoreGraphDatabase leaderDatabase = cluster.awaitLeader().database();
        long transactionVisibleOnLeader = this.transactionIdTracker((GraphDatabaseAPI)leaderDatabase).newestEncounteredTxId();
        try {
            this.transactionIdTracker((GraphDatabaseAPI)readReplicaGraphDatabase).awaitUpToDate(transactionVisibleOnLeader, Duration.ofSeconds(3L));
            Assert.fail((String)"should have thrown exception");
        }
        catch (TransactionFailureException transactionFailureException) {
            // empty catch block
        }
        pollingClient.start();
        this.transactionIdTracker((GraphDatabaseAPI)readReplicaGraphDatabase).awaitUpToDate(transactionVisibleOnLeader, Duration.ofSeconds(3L));
    }

    private TransactionIdTracker transactionIdTracker(GraphDatabaseAPI database) {
        TransactionIdStore transactionIdStore = (TransactionIdStore)database.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        AvailabilityGuard availabilityGuard = (AvailabilityGuard)database.getDependencyResolver().resolveDependency(AvailabilityGuard.class);
        return new TransactionIdTracker(transactionIdStore, availabilityGuard);
    }
}

