/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.Optional;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.test.causalclustering.ClusterRule;

public class CausalClusteringProceduresIT {
    @ClassRule
    public static final ClusterRule clusterRule = new ClusterRule(CausalClusteringProceduresIT.class).withNumberOfCoreMembers(2).withNumberOfReadReplicas(1);
    private static Cluster cluster;

    @BeforeClass
    public static void setup() throws Exception {
        cluster = clusterRule.startCluster();
    }

    @Test
    public void coreProceduresShouldBeAvailable() throws Throwable {
        String[] coreProcs;
        for (String procedure : coreProcs = new String[]{"dbms.cluster.role", "dbms.cluster.routing.getServers", "dbms.cluster.overview", "dbms.procedures", "dbms.listQueries"}) {
            Optional<CoreClusterMember> firstCore = cluster.coreMembers().stream().findFirst();
            assert (firstCore.isPresent());
            CoreGraphDatabase database = firstCore.get().database();
            InternalTransaction tx = database.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)EnterpriseSecurityContext.AUTH_DISABLED);
            Result coreResult = database.execute("CALL " + procedure + "()");
            Assert.assertTrue((String)("core with procedure " + procedure), (boolean)coreResult.hasNext());
            coreResult.close();
            tx.close();
        }
    }

    @Test
    public void readReplicaProceduresShouldBeAvailable() throws Exception {
        String[] readReplicaProcs;
        for (String procedure : readReplicaProcs = new String[]{"dbms.cluster.role", "dbms.procedures", "dbms.listQueries"}) {
            Optional<ReadReplica> firstReadReplica = cluster.readReplicas().stream().findFirst();
            assert (firstReadReplica.isPresent());
            ReadReplicaGraphDatabase database = firstReadReplica.get().database();
            InternalTransaction tx = database.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)EnterpriseSecurityContext.AUTH_DISABLED);
            Result readReplicaResult = database.execute("CALL " + procedure + "()");
            Assert.assertTrue((String)("read replica with procedure " + procedure), (boolean)readReplicaResult.hasNext());
            readReplicaResult.close();
            tx.close();
        }
    }
}

