/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.io.File;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.storecopy.CopiedStoreRecovery;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreFetcher;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.core.state.machines.tx.ConstantTimeRetryStrategy;
import org.neo4j.causalclustering.core.state.machines.tx.RetryStrategy;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.messaging.routing.AlwaysChooseFirstMember;
import org.neo4j.causalclustering.messaging.routing.CoreMemberSelectionStrategy;
import org.neo4j.causalclustering.readreplica.ReadReplicaStartupProcess;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ReadReplicaStartupProcessTest {
    private CopiedStoreRecovery copiedStoreRecovery = (CopiedStoreRecovery)Mockito.mock(CopiedStoreRecovery.class);
    private FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private StoreFetcher storeFetcher = (StoreFetcher)Mockito.mock(StoreFetcher.class);
    private LocalDatabase localDatabase = (LocalDatabase)Mockito.mock(LocalDatabase.class);
    private TopologyService hazelcastTopology = (TopologyService)Mockito.mock(TopologyService.class);
    private CoreTopology clusterTopology = (CoreTopology)Mockito.mock(CoreTopology.class);
    private Lifecycle txPulling = (Lifecycle)Mockito.mock(Lifecycle.class);
    private MemberId memberId = new MemberId(UUID.randomUUID());
    private StoreId localStoreId = new StoreId(1L, 2L, 3L, 4L);
    private StoreId otherStoreId = new StoreId(5L, 6L, 7L, 8L);
    private File storeDir = new File("store-dir");

    @Before
    public void commonMocking() throws StoreIdDownloadFailedException {
        Mockito.when((Object)this.localDatabase.storeDir()).thenReturn((Object)this.storeDir);
        Mockito.when((Object)this.localDatabase.storeId()).thenReturn((Object)this.localStoreId);
        Mockito.when((Object)this.hazelcastTopology.coreServers()).thenReturn((Object)this.clusterTopology);
        Mockito.when((Object)this.clusterTopology.members()).thenReturn((Object)Iterators.asSet((Object[])new MemberId[]{this.memberId}));
    }

    @Test
    public void shouldReplaceEmptyStoreWithRemote() throws Throwable {
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.storeFetcher.getStoreIdOf((MemberId)org.mockito.Matchers.any())).thenReturn((Object)this.otherStoreId);
        ReadReplicaStartupProcess readReplicaStartupProcess = new ReadReplicaStartupProcess(this.fs, this.storeFetcher, this.localDatabase, this.txPulling, (CoreMemberSelectionStrategy)new AlwaysChooseFirstMember(this.hazelcastTopology), (RetryStrategy)new ConstantTimeRetryStrategy(1L, TimeUnit.MILLISECONDS), (LogProvider)NullLogProvider.getInstance(), this.copiedStoreRecovery);
        readReplicaStartupProcess.start();
        ((StoreFetcher)Mockito.verify((Object)this.storeFetcher)).copyStore((MemberId)org.mockito.Matchers.any(), (StoreId)org.mockito.Matchers.any(), (File)org.mockito.Matchers.any());
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).start();
        ((Lifecycle)Mockito.verify((Object)this.txPulling)).start();
    }

    @Test
    public void shouldNotStartWithMismatchedNonEmptyStore() throws Throwable {
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.storeFetcher.getStoreIdOf((MemberId)org.mockito.Matchers.any())).thenReturn((Object)this.otherStoreId);
        ReadReplicaStartupProcess readReplicaStartupProcess = new ReadReplicaStartupProcess(this.fs, this.storeFetcher, this.localDatabase, this.txPulling, (CoreMemberSelectionStrategy)new AlwaysChooseFirstMember(this.hazelcastTopology), (RetryStrategy)new ConstantTimeRetryStrategy(1L, TimeUnit.MILLISECONDS), (LogProvider)NullLogProvider.getInstance(), this.copiedStoreRecovery);
        try {
            readReplicaStartupProcess.start();
            Assert.fail((String)"should have thrown");
        }
        catch (Exception ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"This read replica cannot join the cluster. The local database is not empty and has a mismatching storeId"));
        }
        ((Lifecycle)Mockito.verify((Object)this.txPulling, (VerificationMode)Mockito.never())).start();
    }

    @Test
    public void shouldStartWithMatchingDatabase() throws Throwable {
        Mockito.when((Object)this.storeFetcher.getStoreIdOf((MemberId)org.mockito.Matchers.any())).thenReturn((Object)this.localStoreId);
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)false);
        ReadReplicaStartupProcess readReplicaStartupProcess = new ReadReplicaStartupProcess(this.fs, this.storeFetcher, this.localDatabase, this.txPulling, (CoreMemberSelectionStrategy)new AlwaysChooseFirstMember(this.hazelcastTopology), (RetryStrategy)new ConstantTimeRetryStrategy(1L, TimeUnit.MILLISECONDS), (LogProvider)NullLogProvider.getInstance(), this.copiedStoreRecovery);
        readReplicaStartupProcess.start();
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).start();
        ((Lifecycle)Mockito.verify((Object)this.txPulling)).start();
    }

    @Test
    public void stopShouldStopTheDatabaseAndStopPolling() throws Throwable {
        Mockito.when((Object)this.storeFetcher.getStoreIdOf((MemberId)org.mockito.Matchers.any())).thenReturn((Object)this.localStoreId);
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)false);
        ReadReplicaStartupProcess readReplicaStartupProcess = new ReadReplicaStartupProcess(this.fs, this.storeFetcher, this.localDatabase, this.txPulling, (CoreMemberSelectionStrategy)new AlwaysChooseFirstMember(this.hazelcastTopology), (RetryStrategy)new ConstantTimeRetryStrategy(1L, TimeUnit.MILLISECONDS), (LogProvider)NullLogProvider.getInstance(), this.copiedStoreRecovery);
        readReplicaStartupProcess.start();
        readReplicaStartupProcess.stop();
        ((Lifecycle)Mockito.verify((Object)this.txPulling)).stop();
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).stop();
    }
}

