/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.address;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.messaging.address.UnknownAddressMonitor;
import org.neo4j.logging.Log;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class UnknownAddressMonitorTest {
    @Test
    public void shouldLogFirstFailure() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        UnknownAddressMonitor logger = new UnknownAddressMonitor(log, (Clock)this.testClock(), 100L);
        MemberId to = RaftTestMember.member(0);
        logger.logAttemptToSendToMemberWithNoKnownAddress(to);
        ((Log)Mockito.verify((Object)log)).info(String.format("No address found for %s, probably because the member has been shut down.", to));
    }

    private FakeClock testClock() {
        return Clocks.fakeClock((long)1000000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Test
    public void shouldThrottleLogging() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        FakeClock clock = this.testClock();
        UnknownAddressMonitor logger = new UnknownAddressMonitor(log, (Clock)clock, 1000L);
        MemberId to = RaftTestMember.member(0);
        logger.logAttemptToSendToMemberWithNoKnownAddress(to);
        clock.forward(1L, TimeUnit.MILLISECONDS);
        logger.logAttemptToSendToMemberWithNoKnownAddress(to);
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).info(String.format("No address found for %s, probably because the member has been shut down.", to));
    }

    @Test
    public void shouldResumeLoggingAfterQuietPeriod() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        FakeClock clock = this.testClock();
        UnknownAddressMonitor logger = new UnknownAddressMonitor(log, (Clock)clock, 1000L);
        MemberId to = RaftTestMember.member(0);
        logger.logAttemptToSendToMemberWithNoKnownAddress(to);
        clock.forward(20001L, TimeUnit.MILLISECONDS);
        logger.logAttemptToSendToMemberWithNoKnownAddress(to);
        clock.forward(80001L, TimeUnit.MILLISECONDS);
        logger.logAttemptToSendToMemberWithNoKnownAddress(to);
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)3))).info(String.format("No address found for %s, probably because the member has been shut down.", to));
    }
}

