/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.RaftMessageDecoder;
import org.neo4j.causalclustering.messaging.marshalling.RaftMessageEncoder;
import org.neo4j.storageengine.api.ReadPastEndException;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

@RunWith(value=MockitoJUnitRunner.class)
public class RaftMessageProcessingTest {
    private static ChannelMarshal<ReplicatedContent> serializer = new SafeChannelMarshal<ReplicatedContent>(){

        public void marshal(ReplicatedContent content, WritableChannel channel) throws IOException {
            if (!(content instanceof ReplicatedInteger)) {
                throw new IllegalArgumentException("Unknown content type " + content.getClass());
            }
            channel.put((byte)1);
            channel.putInt(((ReplicatedInteger)content).get());
        }

        public ReplicatedContent unmarshal0(ReadableChannel channel) throws IOException {
            ReplicatedInteger content;
            byte type = channel.get();
            switch (type) {
                case 1: {
                    content = ReplicatedInteger.valueOf(channel.getInt());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown content type 0x%x", type));
                }
            }
            try {
                channel.get();
                throw new IllegalArgumentException("Bytes remain in buffer after deserialization");
            }
            catch (ReadPastEndException readPastEndException) {
                return content;
            }
        }
    };
    private EmbeddedChannel channel;

    @Before
    public void setup() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new RaftMessageEncoder(serializer), new RaftMessageDecoder(serializer)});
    }

    @Test
    public void shouldEncodeAndDecodeVoteRequest() {
        MemberId member = new MemberId(UUID.randomUUID());
        RaftMessages.Vote.Request request = new RaftMessages.Vote.Request(member, 1L, member, 1L, 1L);
        this.channel.writeOutbound(new Object[]{request});
        this.channel.writeInbound(new Object[]{this.channel.readOutbound()});
        Assert.assertEquals((Object)request, (Object)this.channel.readInbound());
    }

    @Test
    public void shouldEncodeAndDecodeVoteResponse() {
        MemberId member = new MemberId(UUID.randomUUID());
        RaftMessages.Vote.Response response = new RaftMessages.Vote.Response(member, 1L, true);
        this.channel.writeOutbound(new Object[]{response});
        this.channel.writeInbound(new Object[]{this.channel.readOutbound()});
        Assert.assertEquals((Object)response, (Object)this.channel.readInbound());
    }

    @Test
    public void shouldEncodeAndDecodeAppendEntriesRequest() {
        MemberId member = new MemberId(UUID.randomUUID());
        RaftLogEntry logEntry = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1));
        RaftMessages.AppendEntries.Request request = new RaftMessages.AppendEntries.Request(member, 1L, 1L, 99L, new RaftLogEntry[]{logEntry}, 1L);
        this.channel.writeOutbound(new Object[]{request});
        this.channel.writeInbound(new Object[]{this.channel.readOutbound()});
        Assert.assertEquals((Object)request, (Object)this.channel.readInbound());
    }

    @Test
    public void shouldEncodeAndDecodeAppendEntriesResponse() {
        MemberId member = new MemberId(UUID.randomUUID());
        RaftMessages.AppendEntries.Response response = new RaftMessages.AppendEntries.Response(member, 1L, false, -1L, 0L);
        this.channel.writeOutbound(new Object[]{response});
        this.channel.writeInbound(new Object[]{this.channel.readOutbound()});
        Assert.assertEquals((Object)response, (Object)this.channel.readInbound());
    }

    @Test
    public void shouldEncodeAndDecodeNewEntryRequest() {
        MemberId member = new MemberId(UUID.randomUUID());
        RaftMessages.NewEntry.Request request = new RaftMessages.NewEntry.Request(member, (ReplicatedContent)ReplicatedInteger.valueOf(12));
        this.channel.writeOutbound(new Object[]{request});
        this.channel.writeInbound(new Object[]{this.channel.readOutbound()});
        Assert.assertEquals((Object)request, (Object)this.channel.readInbound());
    }
}

