/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import java.net.InetSocketAddress;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.messaging.IdleChannelReaperHandler;
import org.neo4j.causalclustering.messaging.NonBlockingChannel;
import org.neo4j.causalclustering.messaging.NonBlockingChannels;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class IdleChannelReaperHandlerTest {
    @Test
    public void shouldRemoveChannelViaCallback() throws Exception {
        AdvertisedSocketAddress address = new AdvertisedSocketAddress("localhost", 1984);
        NonBlockingChannels nonBlockingChannels = new NonBlockingChannels();
        nonBlockingChannels.putIfAbsent(address, (NonBlockingChannel)Mockito.mock(NonBlockingChannel.class));
        IdleChannelReaperHandler reaper = new IdleChannelReaperHandler(nonBlockingChannels);
        InetSocketAddress socketAddress = address.socketAddress();
        Channel channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)channel.remoteAddress()).thenReturn((Object)socketAddress);
        ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)context.channel()).thenReturn((Object)channel);
        reaper.userEventTriggered(context, (Object)IdleStateEvent.ALL_IDLE_STATE_EVENT);
        Assert.assertNull((Object)nonBlockingChannels.get(address));
    }
}

