/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.identity;

import java.io.IOException;
import java.time.Clock;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.state.CoreBootstrapper;
import org.neo4j.causalclustering.core.state.storage.SimpleStorage;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.identity.BindingException;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.ClusterIdentity;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class ClusterIdentityTest {
    private final CoreBootstrapper coreBootstrapper = (CoreBootstrapper)Mockito.mock(CoreBootstrapper.class);
    private final FakeClock clock = Clocks.fakeClock();

    @Test
    public void shouldTimeoutWhenNotBootrappableAndNobodyElsePublishesClusterId() throws Throwable {
        CoreTopology unboundTopology = new CoreTopology(null, false, Collections.emptyMap());
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        Mockito.when((Object)topologyService.coreServers()).thenReturn((Object)unboundTopology);
        ClusterIdentity binder = new ClusterIdentity((SimpleStorage)new StubClusterIdStorage(), topologyService, (LogProvider)NullLogProvider.getInstance(), (Clock)this.clock, () -> this.clock.forward(1L, TimeUnit.SECONDS), 3000L, this.coreBootstrapper);
        try {
            binder.bindToCluster(null);
            Assert.fail((String)"Should have timed out");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        ((CoreTopologyService)Mockito.verify((Object)topologyService, (VerificationMode)Mockito.atLeast((int)2))).coreServers();
    }

    @Test
    public void shouldBindToClusterIdPublishedByAnotherMember() throws Throwable {
        ClusterId publishedClusterId = new ClusterId(UUID.randomUUID());
        CoreTopology unboundTopology = new CoreTopology(null, false, Collections.emptyMap());
        CoreTopology boundTopology = new CoreTopology(publishedClusterId, false, Collections.emptyMap());
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        Mockito.when((Object)topologyService.coreServers()).thenReturn((Object)unboundTopology).thenReturn((Object)boundTopology);
        ClusterIdentity binder = new ClusterIdentity((SimpleStorage)new StubClusterIdStorage(), topologyService, (LogProvider)NullLogProvider.getInstance(), (Clock)this.clock, () -> this.clock.forward(1L, TimeUnit.SECONDS), 3000L, this.coreBootstrapper);
        binder.bindToCluster(null);
        Assert.assertEquals((Object)publishedClusterId, (Object)binder.clusterId());
        ((CoreTopologyService)Mockito.verify((Object)topologyService, (VerificationMode)Mockito.atLeast((int)2))).coreServers();
    }

    @Test
    public void shouldPublishStoredClusterIdIfPreviouslyBound() throws Throwable {
        ClusterId previouslyBoundClusterId = new ClusterId(UUID.randomUUID());
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        Mockito.when((Object)topologyService.setClusterId(previouslyBoundClusterId)).thenReturn((Object)true);
        StubClusterIdStorage clusterIdStorage = new StubClusterIdStorage();
        clusterIdStorage.writeState(previouslyBoundClusterId);
        ClusterIdentity binder = new ClusterIdentity((SimpleStorage)clusterIdStorage, topologyService, (LogProvider)NullLogProvider.getInstance(), (Clock)this.clock, () -> this.clock.forward(1L, TimeUnit.SECONDS), 3000L, this.coreBootstrapper);
        binder.bindToCluster(null);
        ((CoreTopologyService)Mockito.verify((Object)topologyService)).setClusterId(previouslyBoundClusterId);
        Assert.assertEquals((Object)previouslyBoundClusterId, (Object)binder.clusterId());
    }

    @Test
    public void shouldFailToPublishMismatchingStoredClusterId() throws Throwable {
        ClusterId previouslyBoundClusterId = new ClusterId(UUID.randomUUID());
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        Mockito.when((Object)topologyService.setClusterId(previouslyBoundClusterId)).thenReturn((Object)false);
        StubClusterIdStorage clusterIdStorage = new StubClusterIdStorage();
        clusterIdStorage.writeState(previouslyBoundClusterId);
        ClusterIdentity binder = new ClusterIdentity((SimpleStorage)clusterIdStorage, topologyService, (LogProvider)NullLogProvider.getInstance(), (Clock)this.clock, () -> this.clock.forward(1L, TimeUnit.SECONDS), 3000L, this.coreBootstrapper);
        try {
            binder.bindToCluster(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
    }

    @Test
    public void shouldBootstrapWhenBootstrappable() throws Throwable {
        CoreTopology bootstrappableTopology = new CoreTopology(null, true, Collections.emptyMap());
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        Mockito.when((Object)topologyService.coreServers()).thenReturn((Object)bootstrappableTopology);
        Mockito.when((Object)topologyService.setClusterId((ClusterId)Matchers.any())).thenReturn((Object)true);
        ClusterIdentity binder = new ClusterIdentity((SimpleStorage)new StubClusterIdStorage(), topologyService, (LogProvider)NullLogProvider.getInstance(), (Clock)this.clock, () -> this.clock.forward(1L, TimeUnit.SECONDS), 3000L, this.coreBootstrapper);
        ThrowingConsumer snapshotInstaller = (ThrowingConsumer)Mockito.mock(ThrowingConsumer.class);
        binder.bindToCluster(snapshotInstaller);
        ((CoreBootstrapper)Mockito.verify((Object)this.coreBootstrapper)).bootstrap((Set)Matchers.any());
        ((CoreTopologyService)Mockito.verify((Object)topologyService)).setClusterId(binder.clusterId());
        ((ThrowingConsumer)Mockito.verify((Object)snapshotInstaller)).accept(Matchers.any());
    }

    private class StubClusterIdStorage
    implements SimpleStorage<ClusterId> {
        private ClusterId clusterId;

        private StubClusterIdStorage() {
        }

        public boolean exists() {
            return this.clusterId != null;
        }

        public ClusterId readState() throws IOException {
            return this.clusterId;
        }

        public void writeState(ClusterId state) throws IOException {
            this.clusterId = state;
        }
    }
}

