/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery.procedures;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.ReadReplicaAddresses;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.procedures.GetServersProcedure;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.FieldSignature;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

@RunWith(value=Parameterized.class)
public class GetServersProcedureTest {
    private final ClusterId clusterId = new ClusterId(UUID.randomUUID());
    @Parameterized.Parameter(value=0)
    public String ignored;
    @Parameterized.Parameter(value=1)
    public Config config;
    @Parameterized.Parameter(value=2)
    public boolean expectFollowersAsReadEndPoints;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({"with followers as read end points", Config.defaults().augment(Collections.singletonMap(CausalClusteringSettings.cluster_allow_reads_on_followers.name(), "true")), true}, {"no followers as read end points", Config.defaults().augment(Collections.singletonMap(CausalClusteringSettings.cluster_allow_reads_on_followers.name(), "false")), false});
    }

    @Test
    public void ttlShouldBeInSeconds() throws Exception {
        CoreTopologyService coreTopologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        CoreTopology clusterTopology = new CoreTopology(this.clusterId, false, new HashMap());
        Mockito.when((Object)coreTopologyService.coreServers()).thenReturn((Object)clusterTopology);
        Mockito.when((Object)coreTopologyService.readReplicas()).thenReturn((Object)new ReadReplicaTopology(this.clusterId, Collections.emptySet()));
        this.config = this.config.augment(MapUtil.stringMap((String[])new String[]{CausalClusteringSettings.cluster_routing_ttl.name(), "10m"}));
        GetServersProcedure proc = new GetServersProcedure(coreTopologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        List results = Iterators.asList((RawIterator)proc.apply(null, new Object[0]));
        Object[] rows = (Object[])results.get(0);
        long ttlInSeconds = (Long)rows[0];
        Assert.assertEquals((long)600L, (long)ttlInSeconds);
    }

    @Test
    public void shouldHaveCorrectSignature() throws Exception {
        GetServersProcedure proc = new GetServersProcedure(null, null, this.config, (LogProvider)NullLogProvider.getInstance());
        ProcedureSignature signature = proc.signature();
        MatcherAssert.assertThat((Object)signature.outputSignature(), (Matcher)Matchers.containsInAnyOrder((Object[])new FieldSignature[]{new FieldSignature("ttl", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger), new FieldSignature("servers", (Neo4jTypes.AnyType)Neo4jTypes.NTMap)}));
    }

    @Test
    public void shouldProvideReaderAndRouterForSingleCoreSetup() throws Exception {
        CoreTopologyService coreTopologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        HashMap<MemberId, CoreAddresses> coreMembers = new HashMap<MemberId, CoreAddresses>();
        coreMembers.put(RaftTestMember.member(0), GetServersProcedureTest.coreAddresses(0));
        CoreTopology clusterTopology = new CoreTopology(this.clusterId, false, coreMembers);
        Mockito.when((Object)coreTopologyService.coreServers()).thenReturn((Object)clusterTopology);
        Mockito.when((Object)coreTopologyService.readReplicas()).thenReturn((Object)new ReadReplicaTopology(this.clusterId, Collections.emptySet()));
        GetServersProcedure proc = new GetServersProcedure(coreTopologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(proc);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.readAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        builder.routeAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    @Test
    public void shouldReturnCoreServersWithRouteAllCoresButLeaderAsReadAndSingleWriteActions() throws Exception {
        CoreTopologyService coreTopologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)RaftTestMember.member(0));
        HashMap<MemberId, CoreAddresses> coreMembers = new HashMap<MemberId, CoreAddresses>();
        coreMembers.put(RaftTestMember.member(0), GetServersProcedureTest.coreAddresses(0));
        coreMembers.put(RaftTestMember.member(1), GetServersProcedureTest.coreAddresses(1));
        coreMembers.put(RaftTestMember.member(2), GetServersProcedureTest.coreAddresses(2));
        CoreTopology clusterTopology = new CoreTopology(this.clusterId, false, coreMembers);
        Mockito.when((Object)coreTopologyService.coreServers()).thenReturn((Object)clusterTopology);
        Mockito.when((Object)coreTopologyService.readReplicas()).thenReturn((Object)new ReadReplicaTopology(this.clusterId, Collections.emptySet()));
        GetServersProcedure proc = new GetServersProcedure(coreTopologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(proc);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.writeAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        builder.readAddress(GetServersProcedureTest.coreAddresses(1).getRaftServer());
        builder.readAddress(GetServersProcedureTest.coreAddresses(2).getRaftServer());
        builder.routeAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        builder.routeAddress(GetServersProcedureTest.coreAddresses(1).getRaftServer());
        builder.routeAddress(GetServersProcedureTest.coreAddresses(2).getRaftServer());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    @Test
    public void shouldReturnSelfIfOnlyMemberOfTheCluster() throws Exception {
        CoreTopologyService coreTopologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)RaftTestMember.member(0));
        HashMap<MemberId, CoreAddresses> coreMembers = new HashMap<MemberId, CoreAddresses>();
        coreMembers.put(RaftTestMember.member(0), GetServersProcedureTest.coreAddresses(0));
        CoreTopology clusterTopology = new CoreTopology(this.clusterId, false, coreMembers);
        Mockito.when((Object)coreTopologyService.coreServers()).thenReturn((Object)clusterTopology);
        Mockito.when((Object)coreTopologyService.readReplicas()).thenReturn((Object)new ReadReplicaTopology(this.clusterId, Collections.emptySet()));
        GetServersProcedure proc = new GetServersProcedure(coreTopologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(proc);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.writeAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        builder.readAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        builder.routeAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    @Test
    public void shouldReturnTheCoreLeaderForWriteAndReadReplicasAndCoresForReads() throws Exception {
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        HashMap<MemberId, CoreAddresses> coreMembers = new HashMap<MemberId, CoreAddresses>();
        MemberId theLeader = RaftTestMember.member(0);
        coreMembers.put(theLeader, GetServersProcedureTest.coreAddresses(0));
        Mockito.when((Object)topologyService.coreServers()).thenReturn((Object)new CoreTopology(this.clusterId, false, coreMembers));
        Mockito.when((Object)topologyService.readReplicas()).thenReturn((Object)new ReadReplicaTopology(this.clusterId, GetServersProcedureTest.addresses(1)));
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)theLeader);
        GetServersProcedure procedure = new GetServersProcedure(topologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(procedure);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.writeAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        if (this.expectFollowersAsReadEndPoints) {
            builder.readAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        }
        builder.readAddress(GetServersProcedureTest.readReplicaAddresses(1).getClientConnectorAddresses().getBoltAddress());
        builder.routeAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    @Test
    public void shouldReturnCoreMemberAsReadServerIfNoReadReplicasAvailable() throws Exception {
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        HashMap<MemberId, CoreAddresses> coreMembers = new HashMap<MemberId, CoreAddresses>();
        MemberId theLeader = RaftTestMember.member(0);
        coreMembers.put(theLeader, GetServersProcedureTest.coreAddresses(0));
        Mockito.when((Object)topologyService.coreServers()).thenReturn((Object)new CoreTopology(this.clusterId, false, coreMembers));
        Mockito.when((Object)topologyService.readReplicas()).thenReturn((Object)new ReadReplicaTopology(this.clusterId, GetServersProcedureTest.addresses(new int[0])));
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)theLeader);
        GetServersProcedure procedure = new GetServersProcedure(topologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(procedure);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.writeAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        builder.readAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        builder.routeAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    @Test
    public void shouldReturnNoWriteEndpointsIfThereIsNoLeader() throws Exception {
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        HashMap<MemberId, CoreAddresses> coreMembers = new HashMap<MemberId, CoreAddresses>();
        coreMembers.put(RaftTestMember.member(0), GetServersProcedureTest.coreAddresses(0));
        Mockito.when((Object)topologyService.coreServers()).thenReturn((Object)new CoreTopology(this.clusterId, false, coreMembers));
        Mockito.when((Object)topologyService.readReplicas()).thenReturn((Object)new ReadReplicaTopology(this.clusterId, GetServersProcedureTest.addresses(new int[0])));
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenThrow(new Throwable[]{new NoLeaderFoundException()});
        GetServersProcedure procedure = new GetServersProcedure(topologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(procedure);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.readAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        builder.routeAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    @Test
    public void shouldReturnNoWriteEndpointsIfThereIsNoAddressForTheLeader() throws Exception {
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        HashMap<MemberId, CoreAddresses> coreMembers = new HashMap<MemberId, CoreAddresses>();
        coreMembers.put(RaftTestMember.member(0), GetServersProcedureTest.coreAddresses(0));
        Mockito.when((Object)topologyService.coreServers()).thenReturn((Object)new CoreTopology(this.clusterId, false, coreMembers));
        Mockito.when((Object)topologyService.readReplicas()).thenReturn((Object)new ReadReplicaTopology(this.clusterId, GetServersProcedureTest.addresses(new int[0])));
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)RaftTestMember.member(1));
        GetServersProcedure procedure = new GetServersProcedure(topologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(procedure);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.readAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        builder.routeAddress(GetServersProcedureTest.coreAddresses(0).getRaftServer());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    private ClusterView run(GetServersProcedure proc) throws ProcedureException {
        Object[] rows = (Object[])Iterators.asList((RawIterator)proc.apply(null, new Object[0])).get(0);
        Assert.assertEquals((long)((Long)this.config.get(CausalClusteringSettings.cluster_routing_ttl) / 1000L), (long)((Long)rows[0]));
        return ClusterView.parse((List)rows[1]);
    }

    static Set<ReadReplicaAddresses> addresses(int ... ids) {
        return Arrays.stream(ids).mapToObj(GetServersProcedureTest::readReplicaAddresses).collect(Collectors.toSet());
    }

    static CoreAddresses coreAddresses(int id) {
        AdvertisedSocketAddress advertisedSocketAddress = new AdvertisedSocketAddress("localhost", 3000 + id);
        return new CoreAddresses(advertisedSocketAddress, advertisedSocketAddress, new ClientConnectorAddresses(Collections.singletonList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, advertisedSocketAddress))));
    }

    private static ReadReplicaAddresses readReplicaAddresses(int id) {
        AdvertisedSocketAddress advertisedSocketAddress = new AdvertisedSocketAddress("localhost", 3000 + id);
        return new ReadReplicaAddresses(new ClientConnectorAddresses(Collections.singletonList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, advertisedSocketAddress))));
    }

    private static class ClusterView {
        private final Map<GetServersProcedure.Type, Set<AdvertisedSocketAddress>> clusterView;

        private ClusterView(Map<GetServersProcedure.Type, Set<AdvertisedSocketAddress>> clusterView) {
            this.clusterView = clusterView;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterView that = (ClusterView)o;
            return Objects.equals(this.clusterView, that.clusterView);
        }

        public int hashCode() {
            return Objects.hash(this.clusterView);
        }

        public String toString() {
            return "ClusterView{clusterView=" + this.clusterView + '}';
        }

        static ClusterView parse(List<Map<String, Object>> result) {
            HashMap<GetServersProcedure.Type, Set<AdvertisedSocketAddress>> view = new HashMap<GetServersProcedure.Type, Set<AdvertisedSocketAddress>>();
            for (Map<String, Object> single : result) {
                GetServersProcedure.Type role = GetServersProcedure.Type.valueOf((String)((String)single.get("role")));
                Set<AdvertisedSocketAddress> addresses = ClusterView.parse((Object[])single.get("addresses"));
                Assert.assertFalse((boolean)view.containsKey(role));
                view.put(role, addresses);
            }
            return new ClusterView(view);
        }

        private static Set<AdvertisedSocketAddress> parse(Object[] addresses) {
            List list = Stream.of(addresses).map(address -> ClusterView.parse((String)address)).collect(Collectors.toList());
            HashSet<AdvertisedSocketAddress> set = new HashSet<AdvertisedSocketAddress>();
            set.addAll(list);
            Assert.assertEquals((long)list.size(), (long)set.size());
            return set;
        }

        private static AdvertisedSocketAddress parse(String address) {
            String[] split = address.split(":");
            Assert.assertEquals((long)2L, (long)split.length);
            return new AdvertisedSocketAddress(split[0], Integer.valueOf(split[1]).intValue());
        }

        static class Builder {
            private final Map<GetServersProcedure.Type, Set<AdvertisedSocketAddress>> view = new HashMap<GetServersProcedure.Type, Set<AdvertisedSocketAddress>>();

            Builder() {
            }

            Builder readAddress(AdvertisedSocketAddress address) {
                this.addAddress(GetServersProcedure.Type.READ, address);
                return this;
            }

            Builder writeAddress(AdvertisedSocketAddress address) {
                this.addAddress(GetServersProcedure.Type.WRITE, address);
                return this;
            }

            Builder routeAddress(AdvertisedSocketAddress address) {
                this.addAddress(GetServersProcedure.Type.ROUTE, address);
                return this;
            }

            private void addAddress(GetServersProcedure.Type role, AdvertisedSocketAddress address) {
                Set<AdvertisedSocketAddress> advertisedSocketAddresses = this.view.get(role);
                if (advertisedSocketAddresses == null) {
                    advertisedSocketAddresses = new HashSet<AdvertisedSocketAddress>();
                    this.view.put(role, advertisedSocketAddresses);
                }
                advertisedSocketAddresses.add(address);
            }

            public ClusterView build() {
                return new ClusterView(this.view);
            }
        }
    }
}

