/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery.procedures;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.discovery.CoreAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.procedures.GetServersProcedure;
import org.neo4j.causalclustering.discovery.procedures.GetServersProcedureTest;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

@RunWith(value=Parameterized.class)
public class GetServersProcedureRoutingTest {
    @Parameterized.Parameter
    public int serverClass;
    private ClusterId clusterId = new ClusterId(UUID.randomUUID());
    private Config config = Config.defaults();

    @Parameterized.Parameters
    public static Collection<Object> data() {
        return Arrays.asList(1, 2);
    }

    @Test
    public void shouldReturnEndpointsInDifferentOrders() throws Exception {
        CoreTopologyService coreTopologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)RaftTestMember.member(0));
        HashMap<MemberId, CoreAddresses> coreMembers = new HashMap<MemberId, CoreAddresses>();
        coreMembers.put(RaftTestMember.member(0), GetServersProcedureTest.coreAddresses(0));
        coreMembers.put(RaftTestMember.member(1), GetServersProcedureTest.coreAddresses(1));
        coreMembers.put(RaftTestMember.member(2), GetServersProcedureTest.coreAddresses(2));
        CoreTopology clusterTopology = new CoreTopology(this.clusterId, false, coreMembers);
        Mockito.when((Object)coreTopologyService.coreServers()).thenReturn((Object)clusterTopology);
        Mockito.when((Object)coreTopologyService.readReplicas()).thenReturn((Object)new ReadReplicaTopology(this.clusterId, Collections.emptySet()));
        GetServersProcedure proc = new GetServersProcedure(coreTopologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        Object[] endpoints = this.getEndpoints(proc);
        Object[] endpointsInDifferentOrder = this.getEndpoints(proc);
        for (int i = 0; i < 100 && Arrays.deepEquals(endpointsInDifferentOrder, endpoints); ++i) {
            endpointsInDifferentOrder = this.getEndpoints(proc);
        }
        Assert.assertFalse((boolean)Arrays.deepEquals(endpoints, endpointsInDifferentOrder));
    }

    private Object[] getEndpoints(GetServersProcedure proc) throws ProcedureException {
        List results = Iterators.asList((RawIterator)proc.apply(null, new Object[0]));
        Object[] rows = (Object[])results.get(0);
        List servers = (List)rows[1];
        Map endpoints = (Map)servers.get(this.serverClass);
        return (Object[])endpoints.get("addresses");
    }
}

