/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery.procedures;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.discovery.CoreAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.ReadReplicaAddresses;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.procedures.ClusterOverviewProcedure;
import org.neo4j.causalclustering.discovery.procedures.GetServersProcedureTest;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ClusterOverviewProcedureTest {
    @Test
    public void shouldProvideOverviewOfCoreServersAndReadReplicas() throws Exception {
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        HashMap<MemberId, CoreAddresses> coreMembers = new HashMap<MemberId, CoreAddresses>();
        MemberId theLeader = new MemberId(UUID.randomUUID());
        MemberId follower1 = new MemberId(UUID.randomUUID());
        MemberId follower2 = new MemberId(UUID.randomUUID());
        coreMembers.put(theLeader, GetServersProcedureTest.coreAddresses(0));
        coreMembers.put(follower1, GetServersProcedureTest.coreAddresses(1));
        coreMembers.put(follower2, GetServersProcedureTest.coreAddresses(2));
        Set<ReadReplicaAddresses> readReplicas = GetServersProcedureTest.addresses(4, 5);
        Mockito.when((Object)topologyService.coreServers()).thenReturn((Object)new CoreTopology(null, false, coreMembers));
        Mockito.when((Object)topologyService.readReplicas()).thenReturn((Object)new ReadReplicaTopology(null, readReplicas));
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)theLeader);
        ClusterOverviewProcedure procedure = new ClusterOverviewProcedure(topologyService, leaderLocator, (LogProvider)NullLogProvider.getInstance());
        List members = Iterators.asList((RawIterator)procedure.apply(null, new Object[0]));
        MatcherAssert.assertThat((Object)members, (Matcher)IsIterableContainingInOrder.contains((Object[])new Object[][]{{theLeader.getUuid().toString(), new String[]{"bolt://localhost:3000"}, "LEADER"}, {follower1.getUuid().toString(), new String[]{"bolt://localhost:3001"}, "FOLLOWER"}, {follower2.getUuid().toString(), new String[]{"bolt://localhost:3002"}, "FOLLOWER"}, {"00000000-0000-0000-0000-000000000000", new String[]{"bolt://localhost:3004"}, "READ_REPLICA"}, {"00000000-0000-0000-0000-000000000000", new String[]{"bolt://localhost:3005"}, "READ_REPLICA"}}));
    }
}

