/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.causalclustering.core.consensus.schedule.DelayedRenewableTimeoutService;
import org.neo4j.causalclustering.discovery.CoreAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.ReadReplicaAddresses;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.SharedDiscoveryCoreClient;
import org.neo4j.causalclustering.discovery.SharedDiscoveryReadReplicaClient;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.logging.LogProvider;

public class SharedDiscoveryService
implements DiscoveryServiceFactory {
    private final Map<MemberId, CoreAddresses> coreMembers = new HashMap<MemberId, CoreAddresses>();
    private final Set<ReadReplicaAddresses> readReplicaAddresses = new HashSet<ReadReplicaAddresses>();
    private final List<SharedDiscoveryCoreClient> coreClients = new ArrayList<SharedDiscoveryCoreClient>();
    private final Lock lock = new ReentrantLock();
    private final Condition enoughMembers = this.lock.newCondition();
    private ClusterId clusterId;

    public CoreTopologyService coreTopologyService(Config config, MemberId myself, JobScheduler jobScheduler, LogProvider logProvider, LogProvider userLogProvider) {
        SharedDiscoveryCoreClient sharedDiscoveryCoreClient = new SharedDiscoveryCoreClient(this, myself, logProvider, config);
        sharedDiscoveryCoreClient.onCoreTopologyChange(this.coreTopology(sharedDiscoveryCoreClient));
        sharedDiscoveryCoreClient.onReadReplicaTopologyChange(this.readReplicaTopology());
        return sharedDiscoveryCoreClient;
    }

    public TopologyService readReplicaDiscoveryService(Config config, LogProvider logProvider, DelayedRenewableTimeoutService timeoutService, long readReplicaTimeToLiveTimeout, long readReplicaRefreshRate) {
        return new SharedDiscoveryReadReplicaClient(this, config, logProvider);
    }

    void waitForClusterFormation() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.coreMembers.size() < 2) {
                this.enoughMembers.await(10L, TimeUnit.SECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    CoreTopology coreTopology(SharedDiscoveryCoreClient client) {
        this.lock.lock();
        try {
            CoreTopology coreTopology = new CoreTopology(this.clusterId, this.coreClients.size() > 0 && this.coreClients.get(0) == client, Collections.unmodifiableMap(this.coreMembers));
            return coreTopology;
        }
        finally {
            this.lock.unlock();
        }
    }

    ReadReplicaTopology readReplicaTopology() {
        this.lock.lock();
        try {
            ReadReplicaTopology readReplicaTopology = new ReadReplicaTopology(this.clusterId, Collections.unmodifiableSet(this.readReplicaAddresses));
            return readReplicaTopology;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerCoreMember(MemberId memberId, CoreAddresses coreAddresses, SharedDiscoveryCoreClient client) {
        this.lock.lock();
        try {
            this.coreMembers.put(memberId, coreAddresses);
            this.coreClients.add(client);
            this.enoughMembers.signalAll();
            this.notifyCoreClients();
        }
        finally {
            this.lock.unlock();
        }
    }

    void unRegisterCoreMember(MemberId memberId, SharedDiscoveryCoreClient client) {
        this.lock.lock();
        try {
            this.coreMembers.remove(memberId);
            this.coreClients.remove((Object)client);
            this.notifyCoreClients();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void notifyCoreClients() {
        for (SharedDiscoveryCoreClient coreClient : this.coreClients) {
            coreClient.onCoreTopologyChange(this.coreTopology(coreClient));
            coreClient.onReadReplicaTopologyChange(this.readReplicaTopology());
        }
    }

    void registerReadReplica(ReadReplicaAddresses readReplicaAddresses) {
        this.lock.lock();
        try {
            this.readReplicaAddresses.add(readReplicaAddresses);
            this.notifyCoreClients();
        }
        finally {
            this.lock.unlock();
        }
    }

    void unRegisterReadReplica(ReadReplicaAddresses readReplicaAddresses) {
        this.lock.lock();
        try {
            this.readReplicaAddresses.remove(readReplicaAddresses);
            this.notifyCoreClients();
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean casClusterId(ClusterId clusterId) {
        boolean success;
        this.lock.lock();
        try {
            if (this.clusterId == null) {
                success = true;
                this.clusterId = clusterId;
            } else {
                success = this.clusterId.equals((Object)clusterId);
            }
            if (success) {
                this.notifyCoreClients();
            }
        }
        finally {
            this.lock.unlock();
        }
        return success;
    }
}

