/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaAddresses;
import org.neo4j.causalclustering.discovery.SharedDiscoveryService;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class SharedDiscoveryReadReplicaClient
extends LifecycleAdapter
implements TopologyService {
    private final SharedDiscoveryService sharedDiscoveryService;
    private final ReadReplicaAddresses addresses;
    private final Log log;

    SharedDiscoveryReadReplicaClient(SharedDiscoveryService sharedDiscoveryService, Config config, LogProvider logProvider) {
        this.sharedDiscoveryService = sharedDiscoveryService;
        this.addresses = new ReadReplicaAddresses(ClientConnectorAddresses.extractFromConfig((Config)config));
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void start() throws Throwable {
        this.sharedDiscoveryService.registerReadReplica(this.addresses);
        this.log.info("Registered read replica at %s", new Object[]{this.addresses});
    }

    public void stop() throws Throwable {
        this.sharedDiscoveryService.unRegisterReadReplica(this.addresses);
    }

    public CoreTopology coreServers() {
        CoreTopology topology = this.sharedDiscoveryService.coreTopology(null);
        this.log.info("Core topology is %s", new Object[]{topology});
        return topology;
    }
}

