/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.LinkedHashSet;
import java.util.Set;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.SharedDiscoveryService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class SharedDiscoveryCoreClient
extends LifecycleAdapter
implements CoreTopologyService {
    private final SharedDiscoveryService sharedDiscoveryService;
    private final MemberId member;
    private final CoreAddresses coreAddresses;
    private final Set<CoreTopologyService.Listener> listeners = new LinkedHashSet<CoreTopologyService.Listener>();
    private final Log log;
    private CoreTopology coreTopology;
    private ReadReplicaTopology readReplicaTopology;

    SharedDiscoveryCoreClient(SharedDiscoveryService sharedDiscoveryService, MemberId member, LogProvider logProvider, Config config) {
        this.sharedDiscoveryService = sharedDiscoveryService;
        this.member = member;
        this.coreAddresses = SharedDiscoveryCoreClient.extractAddresses(config);
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public synchronized void addCoreTopologyListener(CoreTopologyService.Listener listener) {
        this.listeners.add(listener);
        listener.onCoreTopologyChange(this.coreTopology);
    }

    public boolean setClusterId(ClusterId clusterId) {
        return this.sharedDiscoveryService.casClusterId(clusterId);
    }

    public void refreshCoreTopology() {
    }

    public void start() throws InterruptedException {
        this.sharedDiscoveryService.registerCoreMember(this.member, this.coreAddresses, this);
        this.log.info("Registered core server %s", new Object[]{this.member});
        this.sharedDiscoveryService.waitForClusterFormation();
        this.log.info("Cluster formed");
    }

    public void stop() {
        this.sharedDiscoveryService.unRegisterCoreMember(this.member, this);
        this.log.info("Unregistered core server %s", new Object[]{this.member});
    }

    public ReadReplicaTopology readReplicas() {
        return this.readReplicaTopology;
    }

    public CoreTopology coreServers() {
        return this.coreTopology;
    }

    synchronized void onCoreTopologyChange(CoreTopology coreTopology) {
        this.log.info("Notified of core topology change " + coreTopology);
        this.coreTopology = coreTopology;
        for (CoreTopologyService.Listener listener : this.listeners) {
            listener.onCoreTopologyChange(coreTopology);
        }
    }

    synchronized void onReadReplicaTopologyChange(ReadReplicaTopology readReplicaTopology) {
        this.log.info("Notified of read replica topology change " + readReplicaTopology);
        this.readReplicaTopology = readReplicaTopology;
    }

    private static CoreAddresses extractAddresses(Config config) {
        AdvertisedSocketAddress raftAddress = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.raft_advertised_address);
        AdvertisedSocketAddress transactionSource = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.transaction_advertised_address);
        ClientConnectorAddresses clientConnectorAddresses = ClientConnectorAddresses.extractFromConfig((Config)config);
        return new CoreAddresses(raftAddress, transactionSource, clientConnectorAddresses);
    }
}

