/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.catchup.tx.CatchupPollingProcess;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Level;
import org.neo4j.server.configuration.ClientConnectorSettings;

public class ReadReplica
implements ClusterMember {
    private final Map<String, String> config = MapUtil.stringMap((String[])new String[0]);
    private final DiscoveryServiceFactory discoveryServiceFactory;
    private final File storeDir;
    private final int memberId;
    private final String boltAdvertisedAddress;
    private ReadReplicaGraphDatabase database;
    private Monitors monitors;

    public ReadReplica(File parentDir, int memberId, DiscoveryServiceFactory discoveryServiceFactory, List<AdvertisedSocketAddress> coreMemberHazelcastAddresses, Map<String, String> extraParams, Map<String, IntFunction<String>> instanceExtraParams, String recordFormat) {
        this(parentDir, memberId, discoveryServiceFactory, coreMemberHazelcastAddresses, extraParams, instanceExtraParams, recordFormat, new Monitors());
    }

    public ReadReplica(File parentDir, int memberId, DiscoveryServiceFactory discoveryServiceFactory, List<AdvertisedSocketAddress> coreMemberHazelcastAddresses, Map<String, String> extraParams, Map<String, IntFunction<String>> instanceExtraParams, String recordFormat, Monitors monitors) {
        this.memberId = memberId;
        int boltPort = 9000 + memberId;
        int httpPort = 11000 + memberId;
        String initialHosts = coreMemberHazelcastAddresses.stream().map(SocketAddress::toString).collect(Collectors.joining(","));
        this.config.put("dbms.mode", "READ_REPLICA");
        this.config.put(CausalClusteringSettings.initial_discovery_members.name(), initialHosts);
        this.config.put(GraphDatabaseSettings.store_internal_log_level.name(), Level.DEBUG.name());
        this.config.put(GraphDatabaseSettings.record_format.name(), recordFormat);
        this.config.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
        this.config.put(GraphDatabaseSettings.auth_store.name(), new File(parentDir, "auth").getAbsolutePath());
        this.config.putAll(extraParams);
        for (Map.Entry<String, IntFunction<String>> entry : instanceExtraParams.entrySet()) {
            this.config.put(entry.getKey(), entry.getValue().apply(memberId));
        }
        this.config.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").type.name(), "BOLT");
        this.config.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").enabled.name(), "true");
        this.config.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").listen_address.name(), "127.0.0.1:" + boltPort);
        this.boltAdvertisedAddress = "127.0.0.1:" + boltPort;
        this.config.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").advertised_address.name(), this.boltAdvertisedAddress);
        this.config.put(new ClientConnectorSettings.HttpConnector((String)"http", (ClientConnectorSettings.HttpConnector.Encryption)ClientConnectorSettings.HttpConnector.Encryption.NONE).type.name(), "HTTP");
        this.config.put(new ClientConnectorSettings.HttpConnector((String)"http", (ClientConnectorSettings.HttpConnector.Encryption)ClientConnectorSettings.HttpConnector.Encryption.NONE).enabled.name(), "true");
        this.config.put(new ClientConnectorSettings.HttpConnector((String)"http", (ClientConnectorSettings.HttpConnector.Encryption)ClientConnectorSettings.HttpConnector.Encryption.NONE).listen_address.name(), "127.0.0.1:" + httpPort);
        this.config.put(new ClientConnectorSettings.HttpConnector((String)"http", (ClientConnectorSettings.HttpConnector.Encryption)ClientConnectorSettings.HttpConnector.Encryption.NONE).advertised_address.name(), "127.0.0.1:" + httpPort);
        File neo4jHome = new File(parentDir, "read-replica-" + memberId);
        this.config.put(GraphDatabaseSettings.logs_directory.name(), new File(neo4jHome, "logs").getAbsolutePath());
        this.discoveryServiceFactory = discoveryServiceFactory;
        this.storeDir = new File(new File(new File(neo4jHome, "data"), "databases"), "graph.db");
        this.storeDir.mkdirs();
        this.monitors = monitors;
    }

    public String boltAdvertisedAddress() {
        return this.boltAdvertisedAddress;
    }

    public String routingURI() {
        return String.format("bolt+routing://%s", this.boltAdvertisedAddress);
    }

    @Override
    public void start() {
        this.database = new ReadReplicaGraphDatabase(this.storeDir, this.config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies().monitors(this.monitors), this.discoveryServiceFactory);
    }

    @Override
    public void shutdown() {
        if (this.database != null) {
            this.database.shutdown();
        }
        this.database = null;
    }

    public CatchupPollingProcess txPollingClient() {
        return (CatchupPollingProcess)this.database.getDependencyResolver().resolveDependency(CatchupPollingProcess.class);
    }

    public ReadReplicaGraphDatabase database() {
        return this.database;
    }

    @Override
    public ClientConnectorAddresses clientConnectorAddresses() {
        return ClientConnectorAddresses.extractFromConfig((Config)new Config(this.config));
    }

    public File storeDir() {
        return this.storeDir;
    }

    public String toString() {
        return String.format("ReadReplica{memberId=%d}", this.memberId);
    }

    public String directURI() {
        return String.format("bolt://%s", this.boltAdvertisedAddress);
    }
}

