/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreAddresses;
import org.neo4j.causalclustering.discovery.HazelcastClusterTopology;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class HazelcastClusterTopologyTest {
    @Test
    public void shouldStoreMemberIdentityAndAddressesAsMemberAttributes() throws Exception {
        MemberId memberId = new MemberId(UUID.randomUUID());
        Config config = Config.defaults();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(CausalClusteringSettings.transaction_advertised_address.name(), "tx:1001");
        settings.put(CausalClusteringSettings.raft_advertised_address.name(), "raft:2001");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").type.name(), "BOLT");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").enabled.name(), "true");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").advertised_address.name(), "bolt:3001");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"http").type.name(), "HTTP");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"http").enabled.name(), "true");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"http").advertised_address.name(), "http:3001");
        config.augment(settings);
        Map attributes = HazelcastClusterTopology.buildMemberAttributes((MemberId)memberId, (Config)config).getAttributes();
        Pair extracted = HazelcastClusterTopology.extractMemberAttributes((Member)new MemberImpl(null, null, attributes, false));
        Assert.assertEquals((Object)memberId, (Object)extracted.first());
        CoreAddresses addresses = (CoreAddresses)extracted.other();
        Assert.assertEquals((Object)new AdvertisedSocketAddress("tx", 1001), (Object)addresses.getCatchupServer());
        Assert.assertEquals((Object)new AdvertisedSocketAddress("raft", 2001), (Object)addresses.getRaftServer());
        Assert.assertEquals((Object)new AdvertisedSocketAddress("bolt", 3001), (Object)addresses.getClientConnectorAddresses().getBoltAddress());
    }

    @Test
    public void shouldCollectMembersAsAMap() throws Exception {
        HashSet<MemberImpl> hazelcastMembers = new HashSet<MemberImpl>();
        ArrayList<MemberId> coreMembers = new ArrayList<MemberId>();
        for (int i = 0; i < 5; ++i) {
            MemberId memberId = new MemberId(UUID.randomUUID());
            coreMembers.add(memberId);
            Config config = Config.defaults();
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put(CausalClusteringSettings.transaction_advertised_address.name(), "tx:" + (i + 1));
            settings.put(CausalClusteringSettings.raft_advertised_address.name(), "raft:" + (i + 1));
            settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").type.name(), "BOLT");
            settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").enabled.name(), "true");
            settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").advertised_address.name(), "bolt:" + (i + 1));
            settings.put(new GraphDatabaseSettings.BoltConnector((String)"http").type.name(), "HTTP");
            settings.put(new GraphDatabaseSettings.BoltConnector((String)"http").enabled.name(), "true");
            settings.put(new GraphDatabaseSettings.BoltConnector((String)"http").advertised_address.name(), "http:" + (i + 1));
            config.augment(settings);
            Map attributes = HazelcastClusterTopology.buildMemberAttributes((MemberId)memberId, (Config)config).getAttributes();
            hazelcastMembers.add(new MemberImpl(new Address("localhost", i), null, attributes, false));
        }
        Map coreMemberMap = HazelcastClusterTopology.toCoreMemberMap(hazelcastMembers, (Log)NullLog.getInstance());
        for (int i = 0; i < 5; ++i) {
            CoreAddresses coreAddresses = (CoreAddresses)coreMemberMap.get(coreMembers.get(i));
            Assert.assertEquals((Object)new AdvertisedSocketAddress("tx", i + 1), (Object)coreAddresses.getCatchupServer());
            Assert.assertEquals((Object)new AdvertisedSocketAddress("raft", i + 1), (Object)coreAddresses.getRaftServer());
            Assert.assertEquals((Object)new AdvertisedSocketAddress("bolt", i + 1), (Object)coreAddresses.getClientConnectorAddresses().getBoltAddress());
        }
    }

    @Test
    public void shouldLogAndExcludeMembersWithMissingAttributes() throws Exception {
        HashSet<MemberImpl> hazelcastMembers = new HashSet<MemberImpl>();
        ArrayList<MemberId> coreMembers = new ArrayList<MemberId>();
        for (int i = 0; i < 4; ++i) {
            MemberId memberId = new MemberId(UUID.randomUUID());
            coreMembers.add(memberId);
            Config config = Config.defaults();
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").type.name(), "BOLT");
            settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").enabled.name(), "true");
            settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").advertised_address.name(), "bolt:" + (i + 1));
            settings.put(new GraphDatabaseSettings.BoltConnector((String)"http").type.name(), "HTTP");
            settings.put(new GraphDatabaseSettings.BoltConnector((String)"http").enabled.name(), "true");
            settings.put(new GraphDatabaseSettings.BoltConnector((String)"http").advertised_address.name(), "http:" + (i + 1));
            config.augment(settings);
            Map attributes = HazelcastClusterTopology.buildMemberAttributes((MemberId)memberId, (Config)config).getAttributes();
            if (i == 2) {
                attributes.remove("raft_server");
            }
            hazelcastMembers.add(new MemberImpl(new Address("localhost", i), null, attributes, false));
        }
        Map map = HazelcastClusterTopology.toCoreMemberMap(hazelcastMembers, (Log)NullLog.getInstance());
        Assert.assertThat(map.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new MemberId[]{(MemberId)coreMembers.get(0), (MemberId)coreMembers.get(1), (MemberId)coreMembers.get(3)}));
        Assert.assertThat(map.keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new MemberId[]{(MemberId)coreMembers.get(2)})));
    }
}

