/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.core.Client;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Endpoint;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.query.Predicate;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.schedule.ControlledRenewableTimeoutService;
import org.neo4j.causalclustering.core.consensus.schedule.RenewableTimeoutService;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.HazelcastClient;
import org.neo4j.causalclustering.discovery.HazelcastConnector;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class HazelcastClientTest {
    private Config config() {
        Config defaults = Config.defaults();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").type.name(), "BOLT");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").enabled.name(), "true");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").advertised_address.name(), "bolt:3001");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"http").type.name(), "HTTP");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"http").enabled.name(), "true");
        settings.put(new GraphDatabaseSettings.BoltConnector((String)"http").advertised_address.name(), "http:3001");
        return defaults.augment(settings);
    }

    @Test
    public void shouldReturnTopologyUsingHazelcastMembers() throws Exception {
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        HazelcastClient client = new HazelcastClient(connector, (LogProvider)NullLogProvider.getInstance(), this.config(), (RenewableTimeoutService)new ControlledRenewableTimeoutService(), 60000L, 5000L);
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hazelcastInstance);
        Mockito.when((Object)hazelcastInstance.getAtomicReference(Matchers.anyString())).thenReturn(Mockito.mock(IAtomicReference.class));
        Mockito.when((Object)hazelcastInstance.getSet(Matchers.anyString())).thenReturn((Object)new HazelcastSet());
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)hazelcastInstance.getCluster()).thenReturn((Object)cluster);
        Mockito.when((Object)hazelcastInstance.getExecutorService(Matchers.anyString())).thenReturn((Object)new StubExecutorService());
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1), this.makeMember(2)});
        Mockito.when((Object)cluster.getMembers()).thenReturn((Object)members);
        CoreTopology topology = client.coreServers();
        Assert.assertEquals((long)members.size(), (long)topology.members().size());
    }

    @Test
    public void shouldNotReconnectWhileHazelcastRemainsAvailable() throws Exception {
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        HazelcastClient client = new HazelcastClient(connector, (LogProvider)NullLogProvider.getInstance(), this.config(), (RenewableTimeoutService)new ControlledRenewableTimeoutService(), 60000L, 5000L);
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hazelcastInstance);
        Mockito.when((Object)hazelcastInstance.getAtomicReference(Matchers.anyString())).thenReturn(Mockito.mock(IAtomicReference.class));
        Mockito.when((Object)hazelcastInstance.getSet(Matchers.anyString())).thenReturn((Object)new HazelcastSet());
        Mockito.when((Object)hazelcastInstance.getExecutorService(Matchers.anyString())).thenReturn((Object)new StubExecutorService());
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)hazelcastInstance.getCluster()).thenReturn((Object)cluster);
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1), this.makeMember(2)});
        Mockito.when((Object)cluster.getMembers()).thenReturn((Object)members);
        for (int i = 0; i < 5; ++i) {
            CoreTopology topology = client.coreServers();
            Assert.assertEquals((long)members.size(), (long)topology.members().size());
        }
        ((HazelcastConnector)Mockito.verify((Object)connector, (VerificationMode)Mockito.times((int)1))).connectToHazelcast();
    }

    @Test
    public void shouldReturnEmptyTopologyIfUnableToConnectToHazelcast() throws Exception {
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        LogProvider logProvider = (LogProvider)Mockito.mock(LogProvider.class);
        Log log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)logProvider.getLog((Class)Matchers.any(Class.class))).thenReturn((Object)log);
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)hazelcastInstance.getAtomicReference(Matchers.anyString())).thenReturn(Mockito.mock(IAtomicReference.class));
        Mockito.when((Object)hazelcastInstance.getSet(Matchers.anyString())).thenReturn((Object)new HazelcastSet());
        HazelcastClient client = new HazelcastClient(connector, logProvider, this.config(), (RenewableTimeoutService)new ControlledRenewableTimeoutService(), 60000L, 5000L);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)hazelcastInstance.getCluster()).thenReturn((Object)cluster);
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1), this.makeMember(2)});
        Mockito.when((Object)cluster.getMembers()).thenReturn((Object)members);
        CoreTopology topology = client.coreServers();
        Assert.assertEquals((long)0L, (long)topology.members().size());
        ((Log)Mockito.verify((Object)log)).info(Matchers.startsWith((String)"Failed to read cluster topology from Hazelcast."), (Throwable)Matchers.any(IllegalStateException.class));
    }

    @Test
    public void shouldReturnEmptyTopologyIfInitiallyConnectedToHazelcastButItsNowUnavailable() throws Exception {
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        HazelcastClient client = new HazelcastClient(connector, (LogProvider)NullLogProvider.getInstance(), this.config(), (RenewableTimeoutService)new ControlledRenewableTimeoutService(), 60000L, 5000L);
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hazelcastInstance);
        Mockito.when((Object)hazelcastInstance.getSet(Matchers.anyString())).thenReturn((Object)new HazelcastSet());
        Mockito.when((Object)hazelcastInstance.getCluster()).thenThrow(new Throwable[]{new HazelcastInstanceNotActiveException()});
        CoreTopology topology = client.coreServers();
        Assert.assertEquals((long)0L, (long)topology.members().size());
    }

    @Test
    public void shouldReconnectIfHazelcastUnavailable() throws Exception {
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        HazelcastClient client = new HazelcastClient(connector, (LogProvider)NullLogProvider.getInstance(), this.config(), (RenewableTimeoutService)new ControlledRenewableTimeoutService(), 60000L, 5000L);
        HazelcastInstance hazelcastInstance1 = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        HazelcastInstance hazelcastInstance2 = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hazelcastInstance1).thenReturn((Object)hazelcastInstance2);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)hazelcastInstance1.getCluster()).thenReturn((Object)cluster).thenThrow(new Throwable[]{new HazelcastInstanceNotActiveException()});
        Mockito.when((Object)hazelcastInstance2.getCluster()).thenReturn((Object)cluster);
        Mockito.when((Object)hazelcastInstance1.getAtomicReference(Matchers.anyString())).thenReturn(Mockito.mock(IAtomicReference.class));
        Mockito.when((Object)hazelcastInstance1.getSet(Matchers.anyString())).thenReturn((Object)new HazelcastSet());
        Mockito.when((Object)hazelcastInstance2.getAtomicReference(Matchers.anyString())).thenReturn(Mockito.mock(IAtomicReference.class));
        Mockito.when((Object)hazelcastInstance2.getSet(Matchers.anyString())).thenReturn((Object)new HazelcastSet());
        Mockito.when((Object)hazelcastInstance1.getExecutorService(Matchers.anyString())).thenReturn((Object)new StubExecutorService());
        Mockito.when((Object)hazelcastInstance2.getExecutorService(Matchers.anyString())).thenReturn((Object)new StubExecutorService());
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1), this.makeMember(2)});
        Mockito.when((Object)cluster.getMembers()).thenReturn((Object)members);
        CoreTopology topology1 = client.coreServers();
        Assert.assertEquals((long)members.size(), (long)topology1.members().size());
        CoreTopology topology2 = client.coreServers();
        Assert.assertEquals((long)members.size(), (long)topology2.members().size());
        ((HazelcastConnector)Mockito.verify((Object)connector, (VerificationMode)Mockito.times((int)2))).connectToHazelcast();
    }

    @Test
    public void shouldRegisterReadReplicaInTopology() throws Throwable {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1)});
        Mockito.when((Object)cluster.getMembers()).thenReturn((Object)members);
        Endpoint endpoint = (Endpoint)Mockito.mock(Endpoint.class);
        Mockito.when((Object)endpoint.getUuid()).thenReturn((Object)"12345");
        Client client = (Client)Mockito.mock(Client.class);
        String clientId = "12345";
        Mockito.when((Object)client.getUuid()).thenReturn((Object)"12345");
        ClientService clientService = (ClientService)Mockito.mock(ClientService.class);
        Mockito.when((Object)clientService.getConnectedClients()).thenReturn((Object)Iterators.asSet((Object[])new Client[]{client}));
        HazelcastMap hazelcastMap = new HazelcastMap();
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)hazelcastInstance.getAtomicReference(Matchers.anyString())).thenReturn(Mockito.mock(IAtomicReference.class));
        Mockito.when((Object)hazelcastInstance.getMap(Matchers.anyString())).thenReturn((Object)hazelcastMap);
        Mockito.when((Object)hazelcastInstance.getLocalEndpoint()).thenReturn((Object)endpoint);
        Mockito.when((Object)hazelcastInstance.getExecutorService(Matchers.anyString())).thenReturn((Object)new StubExecutorService());
        Mockito.when((Object)hazelcastInstance.getCluster()).thenReturn((Object)cluster);
        Mockito.when((Object)hazelcastInstance.getClientService()).thenReturn((Object)clientService);
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hazelcastInstance);
        ControlledRenewableTimeoutService renewableTimeoutService = new ControlledRenewableTimeoutService();
        HazelcastClient hazelcastClient = new HazelcastClient(connector, (LogProvider)NullLogProvider.getInstance(), this.config(), (RenewableTimeoutService)renewableTimeoutService, 60000L, 5000L);
        hazelcastClient.start();
        renewableTimeoutService.invokeTimeout(HazelcastClient.REFRESH_READ_REPLICA);
        Assert.assertEquals((long)1L, (long)hazelcastMap.size());
    }

    @Test
    public void shouldRemoveReadReplicasOnGracefulShutdown() throws Throwable {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1)});
        Mockito.when((Object)cluster.getMembers()).thenReturn((Object)members);
        Endpoint endpoint = (Endpoint)Mockito.mock(Endpoint.class);
        Mockito.when((Object)endpoint.getUuid()).thenReturn((Object)"12345");
        Client client = (Client)Mockito.mock(Client.class);
        String clientId = "12345";
        Mockito.when((Object)client.getUuid()).thenReturn((Object)"12345");
        ClientService clientService = (ClientService)Mockito.mock(ClientService.class);
        Mockito.when((Object)clientService.getConnectedClients()).thenReturn((Object)Iterators.asSet((Object[])new Client[]{client}));
        HazelcastMap hazelcastMap = new HazelcastMap();
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)hazelcastInstance.getAtomicReference(Matchers.anyString())).thenReturn(Mockito.mock(IAtomicReference.class));
        Mockito.when((Object)hazelcastInstance.getMap(Matchers.anyString())).thenReturn((Object)hazelcastMap);
        Mockito.when((Object)hazelcastInstance.getLocalEndpoint()).thenReturn((Object)endpoint);
        Mockito.when((Object)hazelcastInstance.getExecutorService(Matchers.anyString())).thenReturn((Object)new StubExecutorService());
        Mockito.when((Object)hazelcastInstance.getCluster()).thenReturn((Object)cluster);
        Mockito.when((Object)hazelcastInstance.getClientService()).thenReturn((Object)clientService);
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hazelcastInstance);
        ControlledRenewableTimeoutService renewableTimeoutService = new ControlledRenewableTimeoutService();
        HazelcastClient hazelcastClient = new HazelcastClient(connector, (LogProvider)NullLogProvider.getInstance(), this.config(), (RenewableTimeoutService)renewableTimeoutService, 60000L, 5000L);
        hazelcastClient.start();
        renewableTimeoutService.invokeTimeout(HazelcastClient.REFRESH_READ_REPLICA);
        hazelcastClient.stop();
        Assert.assertEquals((long)0L, (long)hazelcastMap.size());
    }

    @Test
    public void shouldSwallowNPEFromHazelcast() throws Throwable {
        Endpoint endpoint = (Endpoint)Mockito.mock(Endpoint.class);
        Mockito.when((Object)endpoint.getUuid()).thenReturn((Object)"12345");
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)hazelcastInstance.getLocalEndpoint()).thenReturn((Object)endpoint);
        Mockito.when((Object)hazelcastInstance.getMap(Matchers.anyString())).thenReturn((Object)new HazelcastMap());
        ((HazelcastInstance)Mockito.doThrow((Throwable)new NullPointerException("boom!!!")).when((Object)hazelcastInstance)).shutdown();
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hazelcastInstance);
        ControlledRenewableTimeoutService renewableTimeoutService = new ControlledRenewableTimeoutService();
        HazelcastClient hazelcastClient = new HazelcastClient(connector, (LogProvider)NullLogProvider.getInstance(), this.config(), (RenewableTimeoutService)renewableTimeoutService, 60000L, 5000L);
        hazelcastClient.start();
        renewableTimeoutService.invokeTimeout(HazelcastClient.REFRESH_READ_REPLICA);
        hazelcastClient.stop();
    }

    private Member makeMember(int id) throws UnknownHostException {
        Member member = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)member.getStringAttribute("member_uuid")).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)member.getStringAttribute("transaction_server")).thenReturn((Object)String.format("host%d:%d", id, 7000 + id));
        Mockito.when((Object)member.getStringAttribute("raft_server")).thenReturn((Object)String.format("host%d:%d", id, 6000 + id));
        Mockito.when((Object)member.getStringAttribute("client_connector_addresses")).thenReturn((Object)String.format("bolt://host%d:%d,http://host%d:%d", id, 5000 + id, id, 5000 + id));
        return member;
    }

    private class StubExecutorService
    implements IExecutorService {
        private ExecutorService executor = Executors.newSingleThreadExecutor();

        private StubExecutorService() {
        }

        public void execute(Runnable command, MemberSelector memberSelector) {
        }

        public void executeOnKeyOwner(Runnable command, Object key) {
        }

        public void executeOnMember(Runnable command, Member member) {
        }

        public void executeOnMembers(Runnable command, Collection<Member> members) {
        }

        public void executeOnMembers(Runnable command, MemberSelector memberSelector) {
        }

        public void executeOnAllMembers(Runnable command) {
        }

        public <T> Future<T> submit(Callable<T> task, MemberSelector memberSelector) {
            return null;
        }

        public <T> Future<T> submitToKeyOwner(Callable<T> task, Object key) {
            return null;
        }

        public <T> Future<T> submitToMember(Callable<T> task, Member member) {
            return null;
        }

        public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, Collection<Member> members) {
            return null;
        }

        public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, MemberSelector memberSelector) {
            return null;
        }

        public <T> Map<Member, Future<T>> submitToAllMembers(Callable<T> task) {
            return null;
        }

        public <T> void submit(Runnable task, ExecutionCallback<T> callback) {
        }

        public <T> void submit(Runnable task, MemberSelector memberSelector, ExecutionCallback<T> callback) {
        }

        public <T> void submitToKeyOwner(Runnable task, Object key, ExecutionCallback<T> callback) {
        }

        public <T> void submitToMember(Runnable task, Member member, ExecutionCallback<T> callback) {
        }

        public void submitToMembers(Runnable task, Collection<Member> members, MultiExecutionCallback callback) {
        }

        public void submitToMembers(Runnable task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        }

        public void submitToAllMembers(Runnable task, MultiExecutionCallback callback) {
        }

        public <T> void submit(Callable<T> task, ExecutionCallback<T> callback) {
        }

        public <T> void submit(Callable<T> task, MemberSelector memberSelector, ExecutionCallback<T> callback) {
        }

        public <T> void submitToKeyOwner(Callable<T> task, Object key, ExecutionCallback<T> callback) {
        }

        public <T> void submitToMember(Callable<T> task, Member member, ExecutionCallback<T> callback) {
        }

        public <T> void submitToMembers(Callable<T> task, Collection<Member> members, MultiExecutionCallback callback) {
        }

        public <T> void submitToMembers(Callable<T> task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        }

        public <T> void submitToAllMembers(Callable<T> task, MultiExecutionCallback callback) {
        }

        public LocalExecutorStats getLocalExecutorStats() {
            return null;
        }

        public String getPartitionKey() {
            return null;
        }

        public String getName() {
            return null;
        }

        public String getServiceName() {
            return null;
        }

        public void destroy() {
        }

        public void shutdown() {
        }

        public List<Runnable> shutdownNow() {
            return null;
        }

        public boolean isShutdown() {
            return false;
        }

        public boolean isTerminated() {
            return false;
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        public <T> Future<T> submit(Callable<T> task) {
            return this.executor.submit(task);
        }

        public <T> Future<T> submit(Runnable task, T result) {
            return null;
        }

        public Future<?> submit(Runnable task) {
            return null;
        }

        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return null;
        }

        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return null;
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return null;
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        public void execute(Runnable command) {
        }
    }

    private class HazelcastSet
    implements ISet<Object> {
        private Set<Object> delegate = new HashSet<Object>();

        public String getPartitionKey() {
            throw new IllegalStateException();
        }

        public String getName() {
            throw new IllegalStateException();
        }

        public String getServiceName() {
            throw new IllegalStateException();
        }

        public void destroy() {
            throw new IllegalStateException();
        }

        public String addItemListener(ItemListener<Object> listener, boolean includeValue) {
            throw new IllegalStateException();
        }

        public boolean removeItemListener(String registrationId) {
            throw new IllegalStateException();
        }

        public int size() {
            return this.delegate.size();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        public Iterator<Object> iterator() {
            return this.delegate.iterator();
        }

        public Object[] toArray() {
            return this.delegate.toArray();
        }

        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        public boolean add(Object o) {
            return this.delegate.add(o);
        }

        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        public boolean addAll(Collection<?> c) {
            return this.delegate.addAll(c);
        }

        public boolean retainAll(Collection<?> c) {
            return this.delegate.retainAll(c);
        }

        public boolean removeAll(Collection<?> c) {
            return this.delegate.removeAll(c);
        }

        public void clear() {
            this.delegate.clear();
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public Spliterator<Object> spliterator() {
            return this.delegate.spliterator();
        }
    }

    private class HazelcastMap
    implements IMap<Object, Object> {
        private HashMap delegate = new HashMap();

        private HazelcastMap() {
        }

        public int size() {
            return this.delegate.size();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public Object get(Object key) {
            return this.delegate.get(key);
        }

        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        public Object put(Object key, Object value) {
            return this.delegate.put(key, value);
        }

        public void putAll(Map m) {
            this.delegate.putAll(m);
        }

        public Object remove(Object key) {
            return this.delegate.remove(key);
        }

        public void clear() {
            this.delegate.clear();
        }

        public ICompletableFuture<Object> getAsync(Object key) {
            return null;
        }

        public ICompletableFuture<Object> putAsync(Object key, Object value) {
            return null;
        }

        public ICompletableFuture<Object> putAsync(Object key, Object value, long ttl, TimeUnit timeunit) {
            return null;
        }

        public ICompletableFuture<Void> setAsync(Object o, Object o2) {
            return null;
        }

        public ICompletableFuture<Void> setAsync(Object o, Object o2, long l, TimeUnit timeUnit) {
            return null;
        }

        public ICompletableFuture<Object> removeAsync(Object key) {
            return null;
        }

        public boolean tryRemove(Object key, long timeout, TimeUnit timeunit) {
            return false;
        }

        public boolean tryPut(Object key, Object value, long timeout, TimeUnit timeunit) {
            return false;
        }

        public Object put(Object key, Object value, long ttl, TimeUnit timeunit) {
            return this.delegate.put(key, value);
        }

        public void putTransient(Object key, Object value, long ttl, TimeUnit timeunit) {
        }

        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        public Set<Object> keySet() {
            return this.delegate.keySet();
        }

        public Collection<Object> values() {
            return this.delegate.values();
        }

        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.delegate.entrySet();
        }

        public Set<Object> keySet(Predicate predicate) {
            return null;
        }

        public Set<Map.Entry<Object, Object>> entrySet(Predicate predicate) {
            return null;
        }

        public Collection values(Predicate predicate) {
            return null;
        }

        public Set<Object> localKeySet() {
            return null;
        }

        public Set<Object> localKeySet(Predicate predicate) {
            return null;
        }

        public void addIndex(String attribute, boolean ordered) {
        }

        public LocalMapStats getLocalMapStats() {
            return null;
        }

        public Object executeOnKey(Object key, EntryProcessor entryProcessor) {
            return null;
        }

        public void submitToKey(Object key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        }

        public ICompletableFuture submitToKey(Object key, EntryProcessor entryProcessor) {
            return null;
        }

        public Map<Object, Object> executeOnEntries(EntryProcessor entryProcessor) {
            return null;
        }

        public Map<Object, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
            return null;
        }

        public Object aggregate(Supplier supplier, Aggregation aggregation, JobTracker jobTracker) {
            return null;
        }

        public Object aggregate(Supplier supplier, Aggregation aggregation) {
            return null;
        }

        public Map<Object, Object> executeOnKeys(Set keys, EntryProcessor entryProcessor) {
            return null;
        }

        public Object getOrDefault(Object key, Object defaultValue) {
            return this.delegate.getOrDefault(key, defaultValue);
        }

        public Object putIfAbsent(Object key, Object value) {
            return this.delegate.putIfAbsent(key, value);
        }

        public Object putIfAbsent(Object key, Object value, long ttl, TimeUnit timeunit) {
            return null;
        }

        public boolean remove(Object key, Object value) {
            return this.delegate.remove(key, value);
        }

        public void delete(Object key) {
        }

        public void flush() {
        }

        public void loadAll(boolean replaceExistingValues) {
        }

        public void loadAll(Set keys, boolean replaceExistingValues) {
        }

        public Map getAll(Set keys) {
            return null;
        }

        public boolean replace(Object key, Object oldValue, Object newValue) {
            return this.delegate.replace(key, oldValue, newValue);
        }

        public Object replace(Object key, Object value) {
            return this.delegate.replace(key, value);
        }

        public void set(Object key, Object value) {
        }

        public void set(Object key, Object value, long ttl, TimeUnit timeunit) {
        }

        public void lock(Object key) {
        }

        public void lock(Object key, long leaseTime, TimeUnit timeUnit) {
        }

        public boolean isLocked(Object key) {
            return false;
        }

        public boolean tryLock(Object key) {
            return false;
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit) throws InterruptedException {
            return false;
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit, long leaseTime, TimeUnit leaseTimeunit) throws InterruptedException {
            return false;
        }

        public void unlock(Object key) {
        }

        public void forceUnlock(Object key) {
        }

        public String addLocalEntryListener(MapListener listener) {
            return null;
        }

        public String addLocalEntryListener(EntryListener listener) {
            return null;
        }

        public String addLocalEntryListener(MapListener listener, Predicate predicate, boolean includeValue) {
            return null;
        }

        public String addLocalEntryListener(EntryListener listener, Predicate predicate, boolean includeValue) {
            return null;
        }

        public String addLocalEntryListener(MapListener listener, Predicate predicate, Object key, boolean includeValue) {
            return null;
        }

        public String addLocalEntryListener(EntryListener listener, Predicate predicate, Object key, boolean includeValue) {
            return null;
        }

        public String addInterceptor(MapInterceptor interceptor) {
            return null;
        }

        public void removeInterceptor(String id) {
        }

        public String addEntryListener(MapListener listener, boolean includeValue) {
            return null;
        }

        public String addEntryListener(EntryListener listener, boolean includeValue) {
            return null;
        }

        public boolean removeEntryListener(String id) {
            return false;
        }

        public String addPartitionLostListener(MapPartitionLostListener listener) {
            return null;
        }

        public boolean removePartitionLostListener(String id) {
            return false;
        }

        public String addEntryListener(MapListener listener, Object key, boolean includeValue) {
            return null;
        }

        public String addEntryListener(EntryListener listener, Object key, boolean includeValue) {
            return null;
        }

        public String addEntryListener(MapListener listener, Predicate predicate, boolean includeValue) {
            return null;
        }

        public String addEntryListener(EntryListener listener, Predicate predicate, boolean includeValue) {
            return null;
        }

        public String addEntryListener(MapListener listener, Predicate predicate, Object key, boolean includeValue) {
            return null;
        }

        public String addEntryListener(EntryListener listener, Predicate predicate, Object key, boolean includeValue) {
            return null;
        }

        public EntryView getEntryView(Object key) {
            return null;
        }

        public boolean evict(Object key) {
            return false;
        }

        public void evictAll() {
        }

        public Object computeIfAbsent(Object key, Function mappingFunction) {
            return this.delegate.computeIfAbsent(key, mappingFunction);
        }

        public Object computeIfPresent(Object key, BiFunction remappingFunction) {
            return this.delegate.computeIfPresent(key, remappingFunction);
        }

        public Object compute(Object key, BiFunction remappingFunction) {
            return this.delegate.compute(key, remappingFunction);
        }

        public Object merge(Object key, Object value, BiFunction remappingFunction) {
            return this.delegate.merge(key, value, remappingFunction);
        }

        public void forEach(BiConsumer action) {
            this.delegate.forEach(action);
        }

        public void replaceAll(BiFunction function) {
            this.delegate.replaceAll(function);
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }

        public String getPartitionKey() {
            return null;
        }

        public String getName() {
            return "name";
        }

        public String getServiceName() {
            return "serviceName";
        }

        public void destroy() {
        }
    }
}

