/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.state.CoreState;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.Level;
import org.neo4j.server.configuration.ClientConnectorSettings;

public class CoreClusterMember
implements ClusterMember {
    private final File neo4jHome;
    private final DiscoveryServiceFactory discoveryServiceFactory;
    private final File storeDir;
    private final Map<String, String> config = MapUtil.stringMap((String[])new String[0]);
    private final int serverId;
    private final String boltAdvertisedAddress;
    private CoreGraphDatabase database;

    public CoreClusterMember(int serverId, int clusterSize, List<AdvertisedSocketAddress> addresses, DiscoveryServiceFactory discoveryServiceFactory, String recordFormat, File parentDir, Map<String, String> extraParams, Map<String, IntFunction<String>> instanceExtraParams) {
        this.serverId = serverId;
        int hazelcastPort = 5000 + serverId;
        int txPort = 6000 + serverId;
        int raftPort = 7000 + serverId;
        int boltPort = 8000 + serverId;
        int httpPort = 10000 + serverId;
        String initialMembers = addresses.stream().map(SocketAddress::toString).collect(Collectors.joining(","));
        this.config.put("dbms.mode", "CORE");
        this.config.put(GraphDatabaseSettings.default_advertised_address.name(), "localhost");
        this.config.put(CausalClusteringSettings.initial_discovery_members.name(), initialMembers);
        this.config.put(CausalClusteringSettings.discovery_listen_address.name(), "127.0.0.1:" + hazelcastPort);
        this.config.put(CausalClusteringSettings.transaction_listen_address.name(), "127.0.0.1:" + txPort);
        this.config.put(CausalClusteringSettings.raft_listen_address.name(), "127.0.0.1:" + raftPort);
        this.config.put(CausalClusteringSettings.expected_core_cluster_size.name(), String.valueOf(clusterSize));
        this.config.put(CausalClusteringSettings.leader_election_timeout.name(), "500ms");
        this.config.put(CausalClusteringSettings.raft_messages_log_enable.name(), "true");
        this.config.put(GraphDatabaseSettings.store_internal_log_level.name(), Level.DEBUG.name());
        this.config.put(GraphDatabaseSettings.record_format.name(), recordFormat);
        this.config.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").type.name(), "BOLT");
        this.config.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").enabled.name(), "true");
        this.config.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").listen_address.name(), "127.0.0.1:" + boltPort);
        this.boltAdvertisedAddress = "127.0.0.1:" + boltPort;
        this.config.put(new GraphDatabaseSettings.BoltConnector((String)"bolt").advertised_address.name(), this.boltAdvertisedAddress);
        this.config.put(new ClientConnectorSettings.HttpConnector((String)"http", (ClientConnectorSettings.HttpConnector.Encryption)ClientConnectorSettings.HttpConnector.Encryption.NONE).type.name(), "HTTP");
        this.config.put(new ClientConnectorSettings.HttpConnector((String)"http", (ClientConnectorSettings.HttpConnector.Encryption)ClientConnectorSettings.HttpConnector.Encryption.NONE).enabled.name(), "true");
        this.config.put(new ClientConnectorSettings.HttpConnector((String)"http", (ClientConnectorSettings.HttpConnector.Encryption)ClientConnectorSettings.HttpConnector.Encryption.NONE).listen_address.name(), "127.0.0.1:" + httpPort);
        this.config.put(new ClientConnectorSettings.HttpConnector((String)"http", (ClientConnectorSettings.HttpConnector.Encryption)ClientConnectorSettings.HttpConnector.Encryption.NONE).advertised_address.name(), "127.0.0.1:" + httpPort);
        this.config.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
        this.config.put(GraphDatabaseSettings.auth_store.name(), new File(parentDir, "auth").getAbsolutePath());
        this.config.putAll(extraParams);
        for (Map.Entry<String, IntFunction<String>> entry : instanceExtraParams.entrySet()) {
            this.config.put(entry.getKey(), entry.getValue().apply(serverId));
        }
        this.neo4jHome = new File(parentDir, "server-core-" + serverId);
        this.config.put(GraphDatabaseSettings.logs_directory.name(), new File(this.neo4jHome, "logs").getAbsolutePath());
        this.discoveryServiceFactory = discoveryServiceFactory;
        this.storeDir = new File(new File(new File(this.neo4jHome, "data"), "databases"), "graph.db");
        this.storeDir.mkdirs();
    }

    public String boltAdvertisedAddress() {
        return this.boltAdvertisedAddress;
    }

    public String routingURI() {
        return String.format("bolt+routing://%s", this.boltAdvertisedAddress);
    }

    public String directURI() {
        return String.format("bolt://%s", this.boltAdvertisedAddress);
    }

    @Override
    public void start() {
        this.database = new CoreGraphDatabase(this.storeDir, this.config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies(), this.discoveryServiceFactory);
    }

    @Override
    public void shutdown() {
        if (this.database != null) {
            this.database.shutdown();
            this.database = null;
        }
    }

    public CoreGraphDatabase database() {
        return this.database;
    }

    public File storeDir() {
        return this.storeDir;
    }

    public CoreState coreState() {
        return (CoreState)this.database.getDependencyResolver().resolveDependency(CoreState.class);
    }

    public RaftMachine raft() {
        return (RaftMachine)this.database.getDependencyResolver().resolveDependency(RaftMachine.class);
    }

    public MemberId id() {
        return ((RaftMachine)this.database.getDependencyResolver().resolveDependency(RaftMachine.class)).identity();
    }

    public SortedMap<Long, File> getLogFileNames() throws IOException {
        File clusterStateDir = new File(this.storeDir, "cluster-state");
        File logFilesDir = new File(clusterStateDir, "raft-log");
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            SortedMap sortedMap = new FileNames(logFilesDir).getAllFiles((FileSystemAbstraction)fileSystem, null);
            return sortedMap;
        }
    }

    public File homeDir() {
        return this.neo4jHome;
    }

    public String toString() {
        return String.format("CoreClusterMember{serverId=%d}", this.serverId);
    }

    public int serverId() {
        return this.serverId;
    }

    @Override
    public ClientConnectorAddresses clientConnectorAddresses() {
        return ClientConnectorAddresses.extractFromConfig((Config)new Config(this.config));
    }
}

